
#include <stdio.h>
#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "header.h"

#define SYS_SEC		8
#define SYS_OFF		0xE1
#define SEC_SIZ		256
#define TRK_SIZ		16

struct _file_id{
	char fname[8];
	char type;
	unsigned short start;
	unsigned short length;
};

struct _dir_entry{
	struct _file_id d;
	unsigned char sex;
	unsigned char sec;
	unsigned char trk;
};

struct _ho_head{
	struct _file_id d;
	unsigned char tmp;
	unsigned char sex;
	unsigned short checksum;
};

struct _sys_info{
	unsigned char fsec;
	unsigned char ftrk;
	unsigned char sides;
	unsigned char files;
	unsigned short space;
	char ten[9];
	char label[8];
};

struct _fdi_head{
	char signature[3];
	char write_enable;
	unsigned short cyl_count;
	unsigned short sides_count;
	unsigned short text_offset;
	unsigned short data_offset;
	unsigned short extra_size;
};


struct _sec_head{
	unsigned char c,h,r,n;
	unsigned char flags;
	unsigned short offs;
};

struct _trk_head{
	long offs;
	unsigned short reserved;
	unsigned char sex;
	struct _sec_head *sec;
};

char Title[] = "FDI Disk image created by ZCOP 1.2";

#define TEXT_OFFS	(sizeof(struct _fdi_head) + (sizeof(struct _trk_head) - sizeof(void *)\
+sizeof(struct _sec_head) * 16) * 80)
#define DATA_OFFS	(TEXT_OFFS + sizeof(Title))

struct _fdi_head fdi = {{'F','D','I'},0,80,2,TEXT_OFFS,DATA_OFFS,0};
struct _trk_head *ftrk;

int raw = 0;
int short_hdr = 0;
int fdi_mode = 0;
int xtract = 0;
int cut_mode = 0;
char *valid = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ{}~!@#$%^&()-_=";

valid_name(struct _ho_head *h, char *line)
{
	struct find_t ff;
	int i;

	strncpy(line,h->d.fname,8);
	line[8] = '\0';
	strupr(line);
	for(i=0; i<8; ++i)
		if(!strchr(valid,line[i]))
			line[i]='_';
	if(strchr(valid,h->d.type))
		i = h->d.type;
	else
		i = '$';
	sprintf(line+8,".$%c",i);
	line[11] = line[12] = line[13] = '\0';
	i = 0;
	while(_dos_findfirst(line,_A_NORMAL,&ff)==0)
		line[11] = valid[i++];
}


int dhcheck(struct _ho_head *header)
{
	unsigned short i,j,k;

	for(i=j=0; i<0x0F; ++i){
		k = *((char *)header+i); k &= 0xFF;
		j+=(k*0x0101+i);
	}
	return j;
}


sseek(FILE *f, int sec, int trk)
{
	sec &= 0xFF;
	trk &= 0xFF;
	if(!fdi_mode)
		fseek(f,
			(long)trk * (long)TRK_SIZ * (long)SEC_SIZ +
			(long)sec * (long)SEC_SIZ,
			SEEK_SET);
	else
		fseek(f,
			(long)fdi.data_offset +
			ftrk[trk].offs +
			ftrk[trk].sec[sec].offs,
			SEEK_SET);
}


from_ho(FILE *inf, FILE *df, char *name)
{
	struct _ho_head ho;
	struct _dir_entry d,p;
	struct _sys_info s;
	char buf[SEC_SIZ];
	int i;

	fseek(inf,0L,SEEK_SET);
	if(raw){
		sprintf(d.d.fname,"%-8.8sC",name);
		d.d.start = 25200;
		d.d.length = filelength(fileno(inf));
		d.sex = d.d.length / SEC_SIZ + ((d.d.length % SEC_SIZ) ? 1 : 0);

	}
	else if(!short_hdr){
		fread(&ho,sizeof(struct _ho_head),1,inf);
		if(dhcheck(&ho) != ho.checksum){
			printf("\nSource is the not HOBETA file\n");
			return 0;
		}
		d.d = ho.d;
		d.sex = ho.sex;
	}
	else
		fread(&d,sizeof(struct _dir_entry),1,inf);

	sseek(df,SYS_SEC,0);
	fseek(df,(long)SYS_OFF,SEEK_CUR);
	fread(&s,sizeof(struct _sys_info),1,df);
	d.sec = s.fsec;
	d.trk = s.ftrk;

	if(++s.files >= 255 || s.space < d.sex){
		printf("\n\nNot enough disk space\n");
		return 0;
	}
	printf(" to %-8.8s.%c...\n",d.d.fname,d.d.type);
	for(i=0; i<d.sex; ++i){
		fread(buf,SEC_SIZ,1,inf);
		sseek(df,(int)s.fsec,(int)s.ftrk);
		fwrite(buf,SEC_SIZ,1,df);
		if(++s.fsec >= TRK_SIZ){
			++s.ftrk;
			s.fsec = 0;
		}
		--s.space;
	}
	sseek(df,SYS_SEC,0);
	fseek(df,(long)SYS_OFF,SEEK_CUR);
	fwrite(&s,sizeof(struct _sys_info),1,df);

	sseek(df,0,0);
	do{
		fread(&p,sizeof(struct _dir_entry),1,df);
	}
	while(*p.d.fname != '\x0');
	fseek(df,ftell(df)-(long)sizeof(struct _dir_entry),SEEK_SET);
	fwrite(&d,sizeof(struct _dir_entry),1,df);
	return 1;
}

to_ho(FILE *df,int xtract)
{
	struct _ho_head ho;
	struct _dir_entry d;
	struct _sys_info s;
	char buf[SEC_SIZ], c[50], *ptr;
	int i, j, sec, trk, odd = 0, fnum=0;
	FILE *f;
	long save,clen,sz;

	sseek(df,SYS_SEC,0);
	fseek(df,(long)SYS_OFF,SEEK_CUR);
	fread(&s,sizeof(struct _sys_info),1,df);

	sseek(df,0,0);
	save = ftell(df);
	for(j=0; j<s.files; ++j){
		fseek(df,save,SEEK_SET);
		fread(&d,sizeof(struct _dir_entry),1,df);
		save += sizeof(struct _dir_entry);
		if(*d.d.fname == '\1') continue;
		ho.d = d.d;
		ho.sex = d.sex;
		ho.tmp = 0;
		ho.checksum = dhcheck(&ho);

		if(!xtract){
			printf("%3.3d %8.8s.%c %-5u",
				fnum++,ho.d.fname,ho.d.type,ho.d.length);
			if(++odd <3) printf("\t");
			else {odd = 0; printf("\n");}
		}
		else{
			valid_name(&ho,c);
			printf("Restoring %-8.8s.%c to %s... \n",ho.d.fname,ho.d.type,c);

			if((f=fopen(c,"w+b"))==0){
				printf("\nError creating file %s\n",c);
				return 0;
			}
			if(short_hdr)
				fwrite(&d,sizeof(struct _dir_entry),1,f);
			else if(!raw)
				fwrite(&ho,sizeof(struct _ho_head),1,f);

			sec = d.sec;
			trk = d.trk;
			clen = 0;
			ptr = calloc(d.sex,SEC_SIZ);
			for(i=0; i<d.sex; ++i){
				sseek(df,(int)sec,(int)trk);
				fread(ptr+i*SEC_SIZ,SEC_SIZ,1,df);
			        /*
				clen += SEC_SIZ;
				sz = SEC_SIZ;
	                        */
				/*
				if(cut_mode && clen > d.d.length)
					sz = d.d.length - (clen-SEC_SIZ);
                                */

				/*
				fwrite(buf,SEC_SIZ,1,f);
				*/
				if(++sec >= TRK_SIZ){
					++trk;
					sec = 0;
				}
                                /*
				if(cut_mode && sz != SEC_SIZ) break;
				*/
			}
			if(cut_mode)
				fwrite(ptr,d.d.length,1,f);
			else
				fwrite(ptr,d.sex,SEC_SIZ,f);
			fclose(f);
            free(ptr);
		}
	}
	return 1;
}

char c[_MAX_PATH], d[_MAX_DRIVE], p[_MAX_DIR], f[_MAX_FNAME], e[_MAX_EXT];

main(int argc, char **argv)
{
	FILE *in, *out;
	int i, k=0;
	struct find_t ff;
	long l,pp;
	struct _sys_info sys = {0,1,0x16,0,0x9F0,"\x10"};
	char u[5];

	printf("ZCOP - HOBETA File to TR-DOS Disk Image File copier, version 1.2\n"
		"Copyright (c) 1995, Rick Murray, Chelyabinsk, RU\n\n");
	if(argc < 2){
		printf("Usage:\n"
			   "  ZCOP [options] <image_file> <hobeta_file> [<hobeta_file>..]\n"
			   "    For copy HOBETA files to disk image or\n"
			   "  ZCOP [options] <image_file> \n"
			   "    For view image contents.\n"
			   "  Options:\n"
			   "    -x - Extract files to HOBETA format\n"
			   "    -s - Use short (nonhobeta, but just dir entry) header for files\n"
			   "    -r - Use raw files without any headers\n"
			   "    -c - Cut HOBETA image at length in header\n"
			   "    -f - FDI image file mode\n");
		return 1;
	}
	for(k=1;k<argc;++k){
		if(*argv[k]=='-'){
			switch(toupper(argv[k][1])){
				case 'S':
					short_hdr = 1;
					break;
				case 'F':
					fdi_mode = 1;
					break;
				case 'X':
					xtract = 1;
					break;
				case 'R':
					raw = 1;
					break;
				case 'C':
					cut_mode = 1;
					break;
			}
		}
		else break;
	}
	--k;

	if((out=fopen(argv[1+k],"r+b"))==0){
		if(argc - k == 1){
			printf("File %s not found or open error\n",argv[1+k]);
			return 1;
		}
		else{
			if((out = fopen(argv[1+k],"w+b")) == -1){
				printf("Error create file %s\n",argv[1+k]);
				return 1;
			}
			printf("Creating new disk \"ZX DISK\"...\n");
			if(fdi_mode) fwrite(fdi_head,sizeof(fdi_head),1,out);
				/*write_heads(out);*/
			pp = ftell(out);
			chsize(fileno(out),pp + 655360L);
			/*fseek(out,l,SEEK_SET);*/
			i = 0;
			for(l=0; l<256*8; ++l)
				fwrite(&i,1,1,out);
			fseek(out,pp + (long)(SYS_OFF+0x800),SEEK_SET);
			fwrite(&sys,sizeof(struct _sys_info),1,out);
			fseek(out,pp + 0x8EAL,SEEK_SET);
			fwrite("         \0\0ZX DISK ",19,1,out);
			fseek(out,0,0);
		}
	}
	else{
		fread(u,3,1,out);
		fseek(out,0,0);
		if(filelength(fileno(out)) != 655360L && !strncmp(u,"FDI",3)){
			printf("FDI file\n");
			fdi_mode = 1;
		}
	}

	if(fdi_mode){
		fread(&fdi,sizeof(fdi),1,out);
		fseek(out,sizeof(fdi)+fdi.extra_size,SEEK_SET);
		ftrk = malloc(sizeof(struct _trk_head) * fdi.cyl_count * fdi.sides_count);
		for(i=0; i<fdi.cyl_count * fdi.sides_count; ++i){
			fread(&ftrk[i], sizeof(struct _trk_head) - sizeof(struct _sec_head *),1,out);
			ftrk[i].sec = malloc(sizeof(struct _sec_head) * ftrk[i].sex);
			fread(ftrk[i].sec,sizeof(struct _sec_head) * ftrk[i].sex,1,out);
		}
	}

	if(argc < 3+k)
		to_ho(out,xtract);
	else{
		for(i=2+k; i<argc; ++i){
			_splitpath(argv[i],d,p,f,e);
			if(_dos_findfirst(argv[i],_A_NORMAL,&ff)==0){
				do{
					_makepath(c,d,p,ff.name,"");
					printf("  Copying %s ",ff.name);
					if((in=fopen(c,"r+b"))==-1){
						printf("\n\nFile %s not found or open error\n",c);
						return 1;
					}
					from_ho(in,out,ff.name);
					fclose(in);
				}
				while(_dos_findnext(&ff)==0);
			}
		}
	}
    fclose(out);
	printf("\nDone.\n");
	return 0;
}

/*
write_heads(char *s, FILE *fi)
{
	FILE *q;
	char *buf;
	unsigned len;

	_splitpath(s,d,p,f,e);
	_makepath(c,d,p,"header.bin","");
	if(!(q = fopen(c,"rb"))){
		printf("Image header file not found!\n");
		exit(-1);
	}
	buf = malloc(len = filelength(fileno(q)));
	fread(buf,len,1,q);
	fclose(q);
	fwrite(buf,len,1,fi);
	free(buf);
}
*/




