{$O+,F+}
unit zx;
interface
uses
     crt,dos,
     rcrt,rdos,rstr,rputs,panels;

const
   left=0; right=1;

type
    zxroot=
         record
          name:string[8];
          typ:char;
          start:word;
          length:word;
          totalsec:byte;
          n1sec:byte;
          n1tr:byte;
          mark:boolean;
         end;
    zxdisk=
         record
          n1FreeSec:byte;
          nTr1FreeSec:byte;
          DiskTyp:byte;
          files:byte;
          free:word;
          trdosCode:byte;
          delfiles:byte;
          diskLabel:string[8];
         end;
    hob=
         record
          name:string[8];
          typ:char;
          start:word;
          length:word;
          totalsec:word;
         end;
var
   hobeta:hob;

   zxrootL,zxrootR:array[1..129] of zxroot;
   zxdiskL,zxdiskR:zxdisk;

   zxAL,zxAR:boolean;

   zxlf,zxlfrom, zxrf,zxrfrom, zxf,zxfrom:integer;

   zxLxc,zxRxc,zxLyc,zxRyc:byte;

   trdfile,trdL,trdR:string;
   hobfileL,hobfileR:string;

   buf:array[0..255] of byte;

procedure EmptyBuf;
function bpos(tr,sc:byte):longint;
function ReadSector(rtr,rsc:byte):boolean;
function WriteSector(wtr,wsc:byte):boolean;
function SaveFAT(w:byte):boolean;

procedure history;
procedure zxMDF(w:byte);
procedure zxPDF(from,wh:byte);
procedure zxinfo(w:byte);
function col(s:string; l:word):byte;
function ittrdfile(name:string):boolean;
function ithobeta(name:string):boolean;
procedure copy2pc(trdname:string; index:byte);
procedure copy2zx(hobfile:string; w:byte);
procedure zxDelR;
procedure zxDelL;
function zxSNscanf(scanf_posx, scanf_posy:byte;scanf_str:string):string;

procedure gethobetainfo(name:string);
procedure zxredraw;
procedure zxreprint;
procedure moveL;
procedure moveR;

implementation

uses main,submain,pc;

function bpos(tr,sc:byte):longint;
var a,b,c,d,s:longint;
begin
s:=0;
a:=4096;
b:=tr*a;
s:=s+b;
c:=256;
d:=sc*c;
s:=s+d;
bpos:=s;
end;

procedure EmptyBuf;
var i:byte;
begin
for i:=0 to 255 do buf[i]:=0;
end;


{$I-}
function ReadSector(rtr,rsc:byte):boolean;
var
    rfb:file;
begin
filemode:=0;
assign(rfb,trdfile);
reset(rfb,1); seek(rfb,bpos(rtr,rsc));
blockread(rfb,buf,256);
close(rfb);
if ioresult<>0 then ReadSector:=false else ReadSector:=true;
end;
{$I+}


{$I-}
function WriteSector(wtr,wsc:byte):boolean;
var
    wfb:file;
begin
filemode:=2;
assign(wfb,trdfile); reset(wfb,1); seek(wfb,bpos(wtr,wsc));
blockwrite(wfb,buf,256);
close(wfb);
if ioresult<>0 then WriteSector:=false else WriteSector:=true;
end;
{$I+}





function SaveFAT(w:byte):boolean;
var si,snum,ssc:byte;
begin
if w=right then
 begin
  trdfile:=trdR;
  for ssc:=0 to 7 do
   begin
    EmptyBuf;
    for snum:=0 to 15 do
     begin
      for si:=0 to 7 do
      buf[snum*16+si]:=byte(zxrootR[ssc*16+snum+2].name[si+1]);
      buf[snum*16+ 8]:=byte(zxrootR[ssc*16+snum+2].typ);
      buf[snum*16+ 9]:=lo  (zxrootR[ssc*16+snum+2].start);
      buf[snum*16+10]:=hi  (zxrootR[ssc*16+snum+2].start);
      buf[snum*16+11]:=lo  (zxrootR[ssc*16+snum+2].length);
      buf[snum*16+12]:=hi  (zxrootR[ssc*16+snum+2].length);
      buf[snum*16+13]:=    (zxrootR[ssc*16+snum+2].totalsec);
      buf[snum*16+14]:=    (zxrootR[ssc*16+snum+2].n1sec);
      buf[snum*16+15]:=    (zxrootR[ssc*16+snum+2].n1tr);
     end;
    writesector(0,ssc);
   end;
   EmptyBuf;
   readsector(0,8);
   buf[$e4]:=zxdiskR.files;
   buf[$f4]:=zxdiskR.delfiles;
   buf[$e5]:=lo(zxdiskR.free);
   buf[$e6]:=hi(zxdiskR.free);
   buf[$e1]:=zxdiskR.n1FreeSec;
   buf[$e2]:=zxdiskR.nTr1FreeSec;
   for si:=0 to 7 do buf[$f5+si]:=byte(zxdiskR.disklabel[si+1]);
   writesector(0,8);
 end
else
 begin
  trdfile:=trdL;
  for ssc:=0 to 7 do
   begin
    EmptyBuf;
    for snum:=0 to 15 do
     begin
      for si:=0 to 7 do
      buf[snum*16+si]:=byte(zxrootL[ssc*16+snum+2].name[si+1]);
      buf[snum*16+ 8]:=byte(zxrootL[ssc*16+snum+2].typ);
      buf[snum*16+ 9]:=lo  (zxrootL[ssc*16+snum+2].start);
      buf[snum*16+10]:=hi  (zxrootL[ssc*16+snum+2].start);
      buf[snum*16+11]:=lo  (zxrootL[ssc*16+snum+2].length);
      buf[snum*16+12]:=hi  (zxrootL[ssc*16+snum+2].length);
      buf[snum*16+13]:=    (zxrootL[ssc*16+snum+2].totalsec);
      buf[snum*16+14]:=    (zxrootL[ssc*16+snum+2].n1sec);
      buf[snum*16+15]:=    (zxrootL[ssc*16+snum+2].n1tr);
     end;
    writesector(0,ssc);
   end;
   EmptyBuf;
   readsector(0,8);
   buf[$e4]:=zxdiskL.files;
   buf[$f4]:=zxdiskL.delfiles;
   buf[$e5]:=lo(zxdiskL.free);
   buf[$e6]:=hi(zxdiskL.free);
   buf[$e1]:=zxdiskL.n1FreeSec;
   buf[$e2]:=zxdiskL.nTr1FreeSec;
   for si:=0 to 7 do buf[$f5+si]:=byte(zxdiskL.disklabel[si+1]);
   writesector(0,8);
 end;
end;








procedure getZXdiskInfo(which:byte);
begin
if which=right then trdfile:=trdR else trdfile:=trdL;
readsector(0,8);
if which=left then
 begin
zxdiskL.n1FreeSec:=buf[$e1];
zxdiskL.nTr1FreeSec:=buf[$e2];
zxdiskL.DiskTyp:=buf[$e3];
zxdiskL.files:=buf[$e4];
if zxdiskL.files>128 then zxdiskL.files:=128;
zxdiskL.free:=buf[$e6]*256+buf[$e5];
zxdiskL.trdosCode:=buf[$e7];
zxdiskL.delfiles:=buf[$f4];
zxdiskL.DiskLabel:=chr(buf[$f5])+chr(buf[$f6])+chr(buf[$f7])+chr(buf[$f8])+
                   chr(buf[$f9])+chr(buf[$fa])+chr(buf[$fb])+chr(buf[$fc]);
 end
else
 begin
zxdiskR.n1FreeSec:=buf[$e1];
zxdiskR.nTr1FreeSec:=buf[$e2];
zxdiskR.DiskTyp:=buf[$e3];
zxdiskR.files:=buf[$e4];
if zxdiskR.files>128 then zxdiskR.files:=128;
zxdiskR.free:=buf[$e6]*256+buf[$e5];
zxdiskR.trdosCode:=buf[$e7];
zxdiskR.delfiles:=buf[$f4];
zxdiskR.DiskLabel:=chr(buf[$f5])+chr(buf[$f6])+chr(buf[$f7])+chr(buf[$f8])+
                   chr(buf[$f9])+chr(buf[$fa])+chr(buf[$fb])+chr(buf[$fc]);
 end;
end;



procedure history;
var
    buff:array[1..52] of string;
    full:boolean;
begin
{$I-}
if workdir[length(workdir)]='\' then stemp:=workdir+'trdfiles.his' else stemp:=workdir+'\'+'trdfiles.his';
if checkdirfile(stemp)<>0 then filecreate(stemp);{}
assign(ft,stemp);
reset(ft);
itemp:=0; full:=false;
while not EOF(ft) do
 begin
  readln(ft,stemp);
  if nospace(stemp)<>'' then inc(itemp);
  buff[itemp]:=stemp;
  if itemp>50 then begin full:=true; break end;
 end;
rewrite(ft);
writeln(ft,(trdfile));
append(ft);
for ktemp:=1 to itemp do writeln(ft,buff[ktemp]);
close(ft);
{$I+}
if ioresult<>0 then ;
end;


procedure zxMDF(w:byte);
var def,sec,fl,n,i:integer;
    name:string;
begin
if w=right then trdfile:=trdR else trdfile:=trdL;
if nospace(getof(trdfile,_name)+getof(trdfile,_ext))='' then exit;
getZXdiskInfo(w);
fl:=2;
 for sec:=0 to 7 do
  begin
   def:=0;
   readsector(0,sec);
   for n:=1 to 16 do
    begin
     name:=''; for i:=0 to 7 do name:=name+chr(buf[def+i]);
     if w=right then
      begin
       zxrootR[1].name    :='<<       ';
       zxrootR[1].typ     :='<';
       zxrootR[1].start   :=0;
       zxrootR[1].length  :=0;
       zxrootR[1].totalsec:=0;
       zxrootR[1].n1sec   :=0;
       zxrootR[1].n1tr    :=0;

       zxrootR[fl].name    :=name;
       zxrootR[fl].typ     :=chr(buf[def+8]);
       zxrootR[fl].start   :=buf[def+09]+256*buf[def+10];
       zxrootR[fl].length  :=buf[def+11]+256*buf[def+12];
       zxrootR[fl].totalsec:=buf[def+13];
       zxrootR[fl].n1sec   :=buf[def+14];
       zxrootR[fl].n1tr    :=buf[def+15];
      end
     else
      begin
       zxrootL[1].name    :='<<       ';
       zxrootL[1].typ     :='<';
       zxrootL[1].start   :=0;
       zxrootL[1].length  :=0;
       zxrootL[1].totalsec:=0;
       zxrootL[1].n1sec   :=0;
       zxrootL[1].n1tr    :=0;

       zxrootL[fl].name    :=name;
       zxrootL[fl].typ     :=chr(buf[def+8]);
       zxrootL[fl].start   :=buf[def+09]+256*buf[def+10];
       zxrootL[fl].length  :=buf[def+11]+256*buf[def+12];
       zxrootL[fl].totalsec:=buf[def+13];
       zxrootL[fl].n1sec   :=buf[def+14];
       zxrootL[fl].n1tr    :=buf[def+15];
      end;
     inc(def,16);
     inc(fl);
    end;
  end;

end;



function col(s:string; l:word):byte;
var a:string; c:byte;
begin

c:=lightcyan;
if colored then
 begin
  a:=strlo(s[length(s)]);
  case a[1] of
  'b': c:=lightgreen;
  'm': c:=lightmagenta;
  's': c:=lightmagenta;
  'z': c:=lightred;
  'h': c:=lightgray;
  end;
  if l=6912 then c:=yellow;
  a:=strlo(s[1]);
  case a[1] of
  #0 : c:=lightred{};
  #1 : c:=lightred{};
  end;

 end;
col:=c;
end;



procedure zxPDF(from,wh:byte);
var m,n,x,y,tot,cl,i,ink,paper:byte; s:string;

begin
if (wh=right)and(not zxAR) then exit;
if (wh<>right)and(not zxAL) then exit;
if (wh=left)and(not pLen) then exit;
if (wh=right)and(not pRen) then exit;

if wh=right then i:=zxdiskR.files+1 else i:=zxdiskL.files+1; if i=0 then exit;
if wh<>right then x:=2 else x:=42; y:=putfrom;

if wh=right  then i:=zxdiskR.files+1 else i:=zxdiskL.files+1;
if i>3*panelhi+3*dlist then tot:=3*panelhi+3*dlist else tot:=i;

{if (i>3*panelhi-dlist*3)and(from>i-(3*panelhi-1)+dlist+2) then from:=i-(3*panelhi-1)+dlist+2;
{if wh=right then zxRfrom:=from else zxLfrom:=from;{}

for n:=0 to tot-1 do
 begin
  if wh<>right then
   if from+n>1 then
    begin
     if not zxrootL[from+n].mark then
      cmprint(1,col(zxrootL[from+n].name+zxrootL[from+n].typ,zxrootL[from+n].length),
              x,y,zxrootL[from+n].name+' <'+zxrootL[from+n].typ+'>')
     else
      begin
       if colored then itemp:=0 else itemp:=1;
       cmprint(itemp,yellow,x,y,zxrootL[from+n].name+' <'+zxrootL[from+n].typ+'>')
      end
    end
   else
    begin
      cmprint(1,col(zxrootL[from+n].name+zxrootL[from+n].typ,zxrootL[from+n].length),x,y,zxrootL[from+n].name+'    ')
    end
  else
   if from+n>1 then
    begin
     if not zxrootR[from+n].mark then
      cmprint(1,col(zxrootR[from+n].name+zxrootR[from+n].typ,zxrootR[from+n].length),
              x,y,zxrootR[from+n].name+' <'+zxrootR[from+n].typ+'>')
     else
      begin
       if colored then itemp:=0 else itemp:=1;
       cmprint(itemp,yellow,x,y,zxrootR[from+n].name+' <'+zxrootR[from+n].typ+'>');
      end
    end
   else
    begin
      cmprint(1,col(zxrootR[from+n].name+zxrootR[from+n].typ,zxrootR[from+n].length),x,y,zxrootR[from+n].name+'    ')
    end;
  inc(y);
  if y>(panelhi+2) then begin y:=putfrom; x:=x+13; end;
 end;

for m:=tot to (3*panelhi-1)+3*dlist do
 begin
  cmprint(blue,1,x,y,space(12));
  inc(y); if y>(panelhi+2) then begin y:=putfrom; x:=x+13; end;
 end;

zxprintfullpath(left);
zxprintfullpath(right);

end;




procedure zxinfo(w:byte);
var t,a,x,y,i,paper,ink:byte; marked:boolean; ftots, tots:word; s:string;
    zxname,zxstart,zxlength,zxtotalsec:string;
begin

if (w=right)and(not pRen) then exit;
if (w=left)and(not pLen) then exit;
if (w=right)and(not zxAR) then exit;
if (w=left)and(not zxAL) then exit;

marked:=false; tots:=0; ftots:=0;
if w=right then
 begin
  for i:=2 to zxdiskR.files+1 do if zxrootR[i].mark then begin marked:=true; inc(tots,zxrootR[i].totalsec); inc(ftots); end;
 end
else
 begin
  for i:=2 to zxdiskL.files+1 do if zxrootL[i].mark then begin marked:=true; inc(tots,zxrootL[i].totalsec); inc(ftots); end;
 end;

if colored then ink:=yellow else ink:=lightcyan;

if w=right then
 begin
  x:=42; i:=zxRfrom+zxRf-1;
  zxname:=zxrootR[zxRfrom+zxRf-1].name+' <'+zxrootR[zxRfrom+zxRf-1].typ+'>';
  zxstart:=space(10-length(strr(zxrootR[zxRfrom+zxRf-1].start)))+strr(zxrootR[zxRfrom+zxRf-1].start);
  zxlength:=space(9-length(strr(zxrootR[zxRfrom+zxRf-1].length)))+strr(zxrootR[zxRfrom+zxRf-1].length);
  zxtotalsec:=strr(zxrootR[zxRfrom+zxRf-1].totalsec);
 end
else
 begin
  x:=2; i:=zxLfrom+zxLf-1;
  zxname:=zxrootL[zxLfrom+zxLf-1].name+' <'+zxrootL[zxLfrom+zxLf-1].typ+'>';
  zxstart:=space(10-length(strr(zxrootL[zxLfrom+zxLf-1].start)))+strr(zxrootL[zxLfrom+zxLf-1].start);
  zxlength:=space(9-length(strr(zxrootL[zxLfrom+zxLf-1].length)))+strr(zxrootL[zxLfrom+zxLf-1].length);
  zxtotalsec:=strr(zxrootL[zxLfrom+zxLf-1].totalsec);
 end;

if colored then a:=white else a:=yellow;

if panelinfolines=1 then
begin
if not marked then
 begin
  if i>1 then
   begin
    cmprint(1,lightcyan,x,panellong+3-(panelInfoLines-1),zxname);
    cmprint(1,lightcyan,x+12,panellong+3-(panelInfoLines-1),zxstart);
    cmprint(1,lightcyan,x+20,panellong+3-(panelInfoLines-1),zxlength);
    stemp:='  (     )'; cmprint(1,lightcyan,x+29,panellong+3-(panelInfoLines-1),stemp);
    cmprint(1,white,x+32,panellong+3-(panelInfoLines-1),zxtotalsec);
   end
  else
   begin
    cmprint(1,lightcyan,x,panellong+3-(panelInfoLines-1),copy(zxname,1,8)+space(30));
   end;
 end
else
 begin
  s:='~`'+strr(tots)+'~`  ⬥祭  ~`'+strr(ftots)+'~` 䠩';
  t:=(length(s)-8); t:=(37-t)div 2;
  if length(s)-8<37 then s:=space(t)+s+space(t);
  statuslinecolor(blue,yellow,a,x,panellong+3-(panelInfoLines-1),s);
 end;
end
else
begin
  if i>1 then
   begin
    cmprint(1,lightcyan,x,panellong+3-(panelInfoLines-1),zxname);
    cmprint(1,lightcyan,x+12,panellong+3-(panelInfoLines-1),zxstart);
    cmprint(1,lightcyan,x+20,panellong+3-(panelInfoLines-1),zxlength);
    stemp:='  (     )'; cmprint(1,lightcyan,x+29,panellong+3-(panelInfoLines-1),stemp);
    cmprint(1,white,x+32,panellong+3-(panelInfoLines-1),zxtotalsec);
   end
  else
   begin
    cmprint(1,lightcyan,x,panellong+3-(panelInfoLines-1),copy(zxname,1,8)+space(30));
   end;
if marked then
 begin
  s:='~`'+strr(tots)+'~`  ⬥祭  ~`'+strr(ftots)+'~` 䠩';
  t:=(length(s)-8); t:=(37-t)div 2;
  if length(s)-8<37 then s:=space(t)+s+space(t);
  statuslinecolor(blue,yellow,a,x,panellong+3-(panelInfoLines-1)+1,s);
 end else
  cmprint(1,yellow,x,panellong+3-(panelInfoLines-1)+1,'            ⬥祭'+space(11));
end;

if colored then a:=white else a:=lightcyan;
if colored then i:=7 else i:=lightcyan;
if panelInfoLines=3 then
 begin
  if w=right then
   begin
    s:=(strr(zxdiskR.free));
    s:='~`'+s+'~`  ᢮  ⮬ ᪥';
    x:=60-(length(s)-4)div 2;
    t:=78-(x+length(s)-4);
    if length(s)-4<37 then s:=s+space(t);
    cmprint(1,1,42,panellong+3-(panelInfoLines-1)+2,space(t+1));
   end
  else
   begin
    s:=(strr(zxdiskL.free));
    s:='~`'+s+'~`  ᢮  ⮬ ᪥';
    x:=20-(length(s)-4)div 2;
    t:=38-(x+length(s)-4);
    if length(s)-4<37 then s:=s+space(t);
    cmprint(1,1,2,panellong+3-(panelInfoLines-1)+2,space(t+1));
   end;
  statuslinecolor(blue,i,a,x,panellong+3-(panelInfoLines-1)+2,s);
 end;


end;




function ittrdfile(name:string):boolean;
begin
ittrdfile:=false;
if checkdirfile(name)<>0 then exit;
if filelen(name)<>655360 then exit;
if not ReadSector(0,8) then exit;
if not (buf[$e3] in [$16,$17,$18,$19]) then exit;
if not (buf[$e7] in [$10]) then exit;
{if not (buf[$e6]*256+buf[$e5] in [0..2544]) then exit;}
ittrdfile:=true;
end;


function ithobeta(name:string):boolean;
var
   i,a,b:byte;
   s,c:word;
   hob:array[0..16]of byte;
   fb:file of byte;

begin
{$I-}
ithobeta:=false;
if checkdirfile(name)<>0 then exit;
assign(fb,name); reset(fb); seek(fb,0); for i:=0 to 16 do read(fb,hob[i]); close(fb);
s:=0;
for i:=0 to 14 do s:=s+257*hob[i]+i;
a:=hob[16]; b:=hob[15]; c:=256*a+b;
if c<>s then exit;
ithobeta:=true;
{$I+}
if ioresult<>0 then ;
end;


function hobname(name:string):string;
var i,m:byte; s,d:string;
begin
s:=nospaceLR(mid(name,1,8));
d:=strlo(s);
if (d='com1')or(d='com2')or(d='com3')or(d='com4')or(d='com5')or(d='com6')or
   (d='lpt1')or(d='lpt2')or(d='lpt3')or(d='lpt4')or(d='lpt5')or(d='lpt6')or
   (d='nul')or(d='con')or(d='aux')or(d='prn') then s:=s+d;

for i:=1 to length(s) do
 begin
  if s[i]=' ' then s[i]:='_';
  if s[i] in ['.',':',',','\','/','?','*','>','<','+','"',#39] then s[i]:='-';
  if s[i]=#0 then s[i]:='0';
  if s[i]=#1 then s[i]:='1';
  if s[i]=#2 then s[i]:='2';
  if s[i]=#3 then s[i]:='3';
  if s[i]=#4 then s[i]:='4';
  if s[i]=#5 then s[i]:='5';
  if s[i]=#6 then s[i]:='6';
  if s[i]=#7 then s[i]:='7';
  if s[i]=#8 then s[i]:='8';
  if s[i]=#9 then s[i]:='9';
  if s[i]=#10 then s[i]:='A';
  if s[i]=#11 then s[i]:='B';
  if s[i]=#12 then s[i]:='C';
  if s[i]=#13 then s[i]:='D';
  if s[i]=#14 then s[i]:='E';
  if s[i]=#15 then s[i]:='F';
  if s[i]=#16 then s[i]:='G';
  if s[i]=#17 then s[i]:='H';
  if s[i]=#18 then s[i]:='I';
  if s[i]=#19 then s[i]:='J';
  if s[i]=#20 then s[i]:='K';
  if s[i]=#21 then s[i]:='L';
  if s[i]=#22 then s[i]:='M';
  if s[i]=#23 then s[i]:='N';
  if s[i]=#24 then s[i]:='O';
  if s[i]=#25 then s[i]:='P';
  if s[i]=#26 then s[i]:='Q';
  if s[i]=#27 then s[i]:='R';
  if s[i]=#28 then s[i]:='S';
  if s[i]=#29 then s[i]:='T';
  if s[i]=#30 then s[i]:='U';
  if s[i]=#31 then s[i]:='V';
 end;
s:=s+'.$'+name[10];
hobname:=s;
end;


procedure copy2pc(trdname:string; index:byte);
var
hbuf:array[0..16] of byte;
f1,f2:file;
i,l:longint;
allcount,m,count:word;
towrite,st,fname:string;
t,s,h:byte;

begin
if RT then
 begin
  fname:=zxrootR[index].name+'.'+zxrootR[index].typ;
  for i:=0 to 7 do hbuf[i]:=byte(zxrootR[index].name[i+1]);
  hbuf[8]:=byte(zxrootR[index].typ);
  m:=zxrootR[index].start; hbuf[9]:=lo(m); hbuf[10]:=hi(m);
  m:=zxrootR[index].length; hbuf[11]:=lo(m); hbuf[12]:=hi(m);
  hbuf[13]:=0; hbuf[14]:=byte(zxrootR[index].totalsec);
  m:=0; for i:=0 to 14 do m:=m+257*hbuf[i]+i; hbuf[15]:=lo(m); hbuf[16]:=hi(m);
  t:=zxrootR[index].n1tr;
  s:=zxrootR[index].n1sec;
  allcount:=zxrootR[index].totalsec;
  if ndL[length(ndL)]<>'\' then towrite:=ndL+'\'+hobname(fname) else towrite:=ndL+hobname(fname);
 end
else
 begin
  fname:=zxrootL[index].name+'.'+zxrootL[index].typ;
  for i:=0 to 7 do hbuf[i]:=byte(zxrootL[index].name[i+1]);
  hbuf[8]:=byte(zxrootL[index].typ);
  m:=zxrootL[index].start; hbuf[9]:=lo(m); hbuf[10]:=hi(m);
  m:=zxrootL[index].length; hbuf[11]:=lo(m); hbuf[12]:=hi(m);
  hbuf[13]:=0; hbuf[14]:=byte(zxrootL[index].totalsec);
  m:=0; for i:=0 to 14 do m:=m+257*hbuf[i]+i; hbuf[15]:=lo(m); hbuf[16]:=hi(m);
  t:=zxrootL[index].n1tr;
  s:=zxrootL[index].n1sec;
  allcount:=zxrootL[index].totalsec;
  if ndR[length(ndR)]<>'\' then towrite:=ndR+'\'+hobname(fname) else towrite:=ndR+hobname(fname);
 end;

assign(f2,towrite); rewrite(f2,1);
blockwrite(f2,hbuf,sizeof(hbuf));

trdfile:=trdname; count:=1;
while count<=allcount do
 begin
  readsector(t,s);
  blockwrite(f2,buf,sizeof(buf));
  inc(s); if s>15 then begin inc(t); s:=0; end;
  if t>159 then break;
  inc(count);
 end;
close(f2);
end;






procedure copy2zx(hobfile:string; w:byte);
var kt:word;
begin
                  gethobetainfo(hobfile);

                  assign(ff,hobfile); reset(ff,1); seek(ff,17);
                if w=right then
                 begin
                  trdfile:=trdR;

                  inc(zxdiskR.files);
                  dec(zxdiskR.free,hobeta.totalsec);

                  zxrootR[zxdiskR.files+1].name:=hobeta.name;
                  zxrootR[zxdiskR.files+1].typ:=hobeta.typ;
                  zxrootR[zxdiskR.files+1].start:=hobeta.start;
                  zxrootR[zxdiskR.files+1].length:=hobeta.length;
                  zxrootR[zxdiskR.files+1].totalsec:=lo(hobeta.totalsec);
                  zxrootR[zxdiskR.files+1].n1sec:=zxdiskR.n1freesec;;
                  zxrootR[zxdiskR.files+1].n1tr:=zxdiskR.ntr1freesec;
                  zxrootR[zxdiskR.files+1].mark:=false;

                  for kt:=1 to hobeta.totalsec do
                   begin
                    blockread(ff,buf,sizeof(buf));
                    writesector(zxdiskR.ntr1freesec,zxdiskR.n1freesec);
                    inc(zxdiskR.n1freesec);
                    if zxdiskR.n1freesec>15 then begin zxdiskR.n1freesec:=0; inc(zxdiskR.ntr1freesec); end;
                   end;

                  close(ff);

                  saveFAT(right);
                  zxMDF(right);
                  zxPDF(zxRfrom,right);
                  zxinfo(right);
                 end
                else
                 begin
                  trdfile:=trdL;

                  inc(zxdiskL.files);
                  dec(zxdiskL.free,hobeta.totalsec);

                  zxrootL[zxdiskL.files+1].name:=hobeta.name;
                  zxrootL[zxdiskL.files+1].typ:=hobeta.typ;
                  zxrootL[zxdiskL.files+1].start:=hobeta.start;
                  zxrootL[zxdiskL.files+1].length:=hobeta.length;
                  zxrootL[zxdiskL.files+1].totalsec:=lo(hobeta.totalsec);
                  zxrootL[zxdiskL.files+1].n1sec:=zxdiskL.n1freesec;;
                  zxrootL[zxdiskL.files+1].n1tr:=zxdiskL.ntr1freesec;
                  zxrootL[zxdiskL.files+1].mark:=false;

                  for kt:=1 to hobeta.totalsec do
                   begin
                    blockread(ff,buf,sizeof(buf));
                    writesector(zxdiskL.ntr1freesec,zxdiskL.n1freesec);
                    inc(zxdiskL.n1freesec);
                    if zxdiskL.n1freesec>15 then begin zxdiskL.n1freesec:=0; inc(zxdiskL.ntr1freesec); end;
                   end;

                  close(ff);

                  saveFAT(left);
                  zxMDF(left);
                  zxPDF(zxLfrom,left);
                  zxinfo(left);
                 end;
end;






procedure zxDelR;
begin
              trdfile:=trdR;
              {del for zx right}
              if checkdirfile(trdR)<>0 then exit;
{              if zxRfrom+zxRf-1<>1 then{}
               begin
                itemp:=0; for ktemp:=2 to zxdiskR.files+1 do if zxrootR[ktemp].mark then inc(itemp);
                if (itemp=0)and(zxRfrom+zxRf-1=1) then exit;
                if (itemp=0)and(zxRfrom+zxRf-1<>1) then
                 begin
                  statusbar('~`ESC~` ⬥');
                  stemp:=' 䠩 ~`'+nospaceLR(zxrootR[zxRfrom+zxRf-1].name)+'~` ?';
                  if not cquestion(stemp,rus) then exit;
                 end;
                if (itemp>0) then
                 begin
                  statusbar('~`ESC~` ⬥');
                  stemp:=' 㤠  䠩 ?';
                  if not cquestion(stemp,rus) then exit;
                 end;

                itemp:=0;
                for ktemp:=2 to zxdiskR.files+1 do
                 begin
                  if zxrootR[ktemp].mark then
                   begin
                    inc(itemp);
                    if ktemp<>zxdiskR.files+1 then
                     begin
                      if zxrootR[ktemp].name[1]<>char(1) then
                       begin
                        inc(zxdiskR.delfiles);
                        zxrootR[ktemp].name[1]:=char(1);
                       end;
                     end
                    else
                     begin
                      if zxrootR[ktemp].name[1]<>char(0) then
                       begin
                        zxdiskR.n1FreeSec:=zxrootR[ktemp].n1sec;
                        zxdiskR.ntr1FreeSec:=zxrootR[ktemp].n1tr;
                        if zxrootR[ktemp].name[1]=char(1) then dec(zxdiskR.delfiles);
                        dec(zxdiskR.files);
                        zxrootR[ktemp].name[1]:=char(0);
                        inc(zxdiskR.free,zxrootR[ktemp].totalsec);
                        if zxdiskR.files+1>59 then dec(zxRfrom);{}
                       end;
                     end;
                    zxrootR[ktemp].mark:=false;
                   end;
                 end;

                if (itemp=0)and(zxRfrom+zxRf-1<>1) then
                 if (zxRfrom+zxRf-1<>zxdiskR.files+1) then
                  begin
                   if zxrootR[zxRfrom+zxRf-1].name[1]<>char(1) then
                    begin
                     inc(zxdiskR.delfiles);
                     zxrootR[zxRfrom+zxRf-1].name[1]:=char(1);
                    end;
                  end
                 else
                  begin
                   if zxrootR[zxRfrom+zxRf-1].name[1]<>char(0) then
                    begin
                     zxdiskR.n1FreeSec:=zxrootR[zxRfrom+zxRf-1].n1sec;
                     zxdiskR.ntr1FreeSec:=zxrootR[zxRfrom+zxRf-1].n1tr;
                     if zxrootR[zxRfrom+zxRf-1].name[1]=char(1) then dec(zxdiskR.delfiles);
                     dec(zxdiskR.files);
                     zxrootR[zxRfrom+zxRf-1].name[1]:=char(0);
                     inc(zxdiskR.free,zxrootR[zxRfrom+zxRf-1].totalsec);
                     if zxdiskR.files+1>59 then dec(zxRfrom);{}
                    end;
                  end;

                SaveFAT(right);
                zxredraw;
               end;
end;





procedure zxDelL;
begin
              trdfile:=trdL;
              {del for zx left}
              if checkdirfile(trdL)<>0 then exit;
{              if (zxLfrom+zxLf-1<>1) then{}
               begin
                itemp:=0; for ktemp:=2 to zxdiskL.files+1 do if zxrootL[ktemp].mark then inc(itemp);
                if (itemp=0)and(zxLfrom+zxLf-1=1) then exit;
                if (itemp=0)and(zxLfrom+zxLf-1<>1) then
                 begin
                  statusbar('~`ESC~` ⬥');
                  stemp:=' 䠩 ~`'+nospaceLR(zxrootL[zxLfrom+zxLf-1].name)+'~` ?';
                  if not cquestion(stemp,rus) then exit;
                 end;
                if (itemp>0) then
                 begin
                  statusbar('~`ESC~` ⬥');
                  stemp:=' 㤠  䠩 ?';
                  if not cquestion(stemp,rus) then exit;
                 end;

                itemp:=0;
                for ktemp:=2 to zxdiskL.files+1 do
                 begin
                  if zxrootL[ktemp].mark then
                   begin
                    inc(itemp);
                    if ktemp<>zxdiskL.files+1 then
                     begin
                      if zxrootL[ktemp].name[1]<>char(1) then
                       begin
                        inc(zxdiskL.delfiles);
                        zxrootL[ktemp].name[1]:=char(1);
                       end;
                     end
                    else
                     begin
                      if zxrootL[ktemp].name[1]<>char(0) then
                       begin
                        zxdiskL.n1FreeSec:=zxrootL[ktemp].n1sec;
                        zxdiskL.ntr1FreeSec:=zxrootL[ktemp].n1tr;
                        if zxrootL[ktemp].name[1]=char(1) then dec(zxdiskL.delfiles);
                        dec(zxdiskL.files);
                        zxrootL[ktemp].name[1]:=char(0);
                        inc(zxdiskL.free,zxrootL[ktemp].totalsec);
                        if zxdiskL.files+1>59 then dec(zxLfrom);{}
                       end;
                     end;
                    zxrootL[ktemp].mark:=false;
                   end;
                 end;

                if (itemp=0)and(zxLfrom+zxLf-1<>1) then
                 if (zxLfrom+zxLf-1<>zxdiskL.files+1) then
                  begin
                   if zxrootL[zxLfrom+zxLf-1].name[1]<>char(1) then
                    begin
                     inc(zxdiskL.delfiles);
                     zxrootL[zxLfrom+zxLf-1].name[1]:=char(1);
                    end;
                  end
                 else
                  begin
                   if zxrootL[zxLfrom+zxLf-1].name[1]<>char(0) then
                    begin
                     zxdiskL.n1FreeSec:=zxrootL[zxLfrom+zxLf-1].n1sec;
                     zxdiskL.ntr1FreeSec:=zxrootL[zxLfrom+zxLf-1].n1tr;
                     if zxrootL[zxLfrom+zxLf-1].name[1]=char(1) then dec(zxdiskL.delfiles);
                     dec(zxdiskL.files);
                     zxrootL[zxLfrom+zxLf-1].name[1]:=char(0);
                     inc(zxdiskL.free,zxrootL[zxLfrom+zxLf-1].totalsec);
                     if zxdiskL.files+1>59 then dec(zxLfrom);{}
                    end;
                  end;

                SaveFAT(left);
                zxredraw;
               end;
end;





{============================================================================}
{== SCANF ===================================================================}
{============================================================================}
function zxSNscanf(scanf_posx, scanf_posy:byte;scanf_str:string):string;
var
     scanf_kod:char;
     scanf_x:byte;
     scanf_str_old:string;
label loop;
begin
scanf_esc:=false;
scanf_str_old:=scanf_str;
scanf_x:=1;
{scanf_str:=scanf_str+space(12-length(scanf_str));{}
loop:
mprint(scanf_posx,scanf_posy,scanf_str);
gotoxy(scanf_posx+scanf_x-1,scanf_posy);
scanf_kod:=readkey;
if scanf_kod=#27 then begin zxsnscanf:=scanf_str_old; scanf_esc:=true; exit; end;
if scanf_kod=#13 then begin zxsnscanf:=scanf_str; exit; end;

if (scanf_kod in[' '..#127])and(scanf_x<=length(scanf_str)) then
 begin
  scanf_str[scanf_x]:=scanf_kod;
  inc(scanf_x);
  if scanf_x=9 then inc(scanf_x);
  if scanf_x=10 then inc(scanf_x);
 end;
{if scanf_kod='.' then scanf_x:=11;{}

if scanf_kod=#0 then
 begin
  scanf_kod:=readkey;
  if scanf_kod=#77 then begin inc(scanf_x); if scanf_x=9 then inc(scanf_x); if scanf_x=10 then inc(scanf_x); end;
  if scanf_kod=#75 then begin dec(scanf_x); if scanf_x=10 then dec(scanf_x); if scanf_x=9 then dec(scanf_x); end;
 end;

if scanf_x<1 then scanf_x:=1;
if scanf_x>11 then begin scanf_x:=11; end;
goto loop;
end;






procedure gethobetainfo(name:string);
var
   i,a,b:byte;
   s,c:word;
   hob:array[0..16]of byte;
   fb:file of byte;

begin
{$I-}
if checkdirfile(name)<>0 then exit;
assign(fb,name); reset(fb); seek(fb,0); for i:=0 to 16 do read(fb,hob[i]); close(fb);
hobeta.name:='';
for i:=0 to 7 do hobeta.name:=hobeta.name+char(hob[i]);
hobeta.typ:=char(hob[8]);
hobeta.start:=hob[9]+256*hob[10];
hobeta.length:=hob[11]+256*hob[12];
hobeta.totalsec:=256*hob[13]+hob[14];
{$I+}
if ioresult<>0 then ;
end;






procedure zxredraw;
var old:string;
begin
old:=trdfile;

trdfile:=trdL;
zxMDF(left);
if zxdiskL.files+1>(3*panelhi) then
 begin
  itemp:=3*panelhi;
  if zxLfrom>zxdiskL.files+2-(3*panelhi) then zxLfrom:=zxdiskL.files+2-3*panelhi;
 end
else
 begin
  itemp:=zxdiskL.files+1;
  zxLfrom:=1;
 end;
if zxLf>itemp then zxLf:=itemp;
if zxLfrom<1 then zxLfrom:=1;

trdfile:=trdR;
zxMDF(right);
if zxdiskR.files+1>(3*panelhi) then
 begin
  itemp:=3*panelhi;
  if zxRfrom>zxdiskR.files+2-(3*panelhi) then zxRfrom:=zxdiskR.files+2-3*panelhi;

 end
else
 begin
  itemp:=zxdiskR.files+1;
  zxRfrom:=1;
 end;
if zxRf>itemp then zxRf:=itemp;
if zxRfrom<1 then zxRfrom:=1;

zxPDF(zxLfrom,left);
zxinfo(left);
zxPDF(zxRfrom,right);
zxinfo(right);

trdfile:=old;
end;




procedure zxreprint;
begin

{zxMDF(left);{}
if zxdiskL.files+1>(3*panelhi) then
 begin
  itemp:=3*panelhi;
  if zxLfrom>zxdiskL.files+2-(3*panelhi) then zxLfrom:=zxdiskL.files+2-3*panelhi;
 end
else
 begin
  itemp:=zxdiskL.files+1;
  zxLfrom:=1;
 end;
if zxLf>itemp then zxLf:=itemp;
zxPDF(zxLfrom,left); showcur;
zxinfo(left);

{zxMDF(right);{}
if zxdiskR.files+1>(3*panelhi) then
 begin
  itemp:=3*panelhi;
  if zxRfrom>zxdiskR.files+2-(3*panelhi) then zxRfrom:=zxdiskR.files+2-3*panelhi;
 end
else
 begin
  itemp:=zxdiskR.files+1;
  zxRfrom:=1;
 end;
if zxRf>itemp then zxRf:=itemp;
zxPDF(zxRfrom,right); showcur;
zxinfo(right);
end;





procedure moveL;
var fr,tr,sc,a,n,i,files,delfiles,pos,now:word; s:string;
begin
trdfile:=trdL;
curoff;
if zxdiskL.delfiles=0 then exit;
files:=0; delfiles:=0; fr:=0;
for i:=2 to zxdiskL.files+1 do if zxrootL[i].name[1] in [#0,#1] then inc(delfiles) else inc(files);
i:=2; while not(zxrootL[i].name[1] in [#0,#1]) do inc(i); pos:=i;

statusbar('~`ESC~` ⬥');
if not cquestion('        㢥p ?        ',rus) then exit;
statusbar('⭥...');


zxdiskL.n1freesec:=zxrootL[i].n1sec;
zxdiskL.ntr1freesec:=zxrootL[i].n1tr;

for n:=i to zxdiskL.files+1 do
 begin
  if zxrootL[n].name[1]<>#1 then
   begin

    zxrootL[pos].n1tr:=zxdiskL.ntr1freesec;
    zxrootL[pos].n1sec:=zxdiskL.n1freesec;
    tr:=zxrootL[n].n1tr; sc:=zxrootL[n].n1sec;
    for a:=1 to zxrootL[n].totalsec do
     begin
      readsector(tr,sc);
      writesector(zxdiskL.ntr1freesec,zxdiskL.n1freesec);
      inc(sc); if sc>15 then begin sc:=0; inc(tr); end;
      inc(zxdiskL.n1freesec);
      if zxdiskL.n1freesec>15 then begin zxdiskL.n1freesec:=0; inc(zxdiskL.ntr1freesec); end;
     end;

    zxrootL[pos].name    :=zxrootL[n].name;
    zxrootL[pos].typ     :=zxrootL[n].typ;
    zxrootL[pos].start   :=zxrootL[n].start;
    zxrootL[pos].length  :=zxrootL[n].length;
    zxrootL[pos].totalsec:=zxrootL[n].totalsec;
    zxrootL[pos].mark    :=false;

    inc(pos);
    zxrootL[pos].name[1]:=#0;
   end else inc(fr,zxrootL[n].totalsec);
 end;

zxdiskL.files:=pos-2; zxdiskL.delfiles:=0;
inc(zxdiskL.free,fr);

saveFAT(left);
zxredraw;
end;




procedure moveR;
var fr,tr,sc,a,n,i,files,delfiles,pos:word; s:string;
begin
trdfile:=trdR;
curoff;
if zxdiskR.delfiles=0 then exit;
files:=0; delfiles:=0; fr:=0;
for i:=2 to zxdiskR.files+1 do if zxrootR[i].name[1] in [#0,#1] then inc(delfiles) else inc(files);
i:=2; while not(zxrootR[i].name[1] in [#0,#1]) do inc(i); pos:=i;
statusbar('~`ESC~` ⬥');
if not cquestion('        㢥p ?        ',rus) then exit;
statusbar('⭥...');
zxdiskR.n1freesec:=zxrootR[i].n1sec;
zxdiskR.ntr1freesec:=zxrootR[i].n1tr;

for n:=i to zxdiskR.files+1 do
 begin
  if zxrootR[n].name[1]<>#1 then
   begin
    zxrootR[pos].n1tr:=zxdiskR.ntr1freesec;
    zxrootR[pos].n1sec:=zxdiskR.n1freesec;
    tr:=zxrootR[n].n1tr; sc:=zxrootR[n].n1sec;
    for a:=1 to zxrootR[n].totalsec do
     begin
      readsector(tr,sc);
      writesector(zxdiskR.ntr1freesec,zxdiskR.n1freesec);
      inc(sc); if sc>15 then begin sc:=0; inc(tr); end;
      inc(zxdiskR.n1freesec);
      if zxdiskR.n1freesec>15 then begin zxdiskR.n1freesec:=0; inc(zxdiskR.ntr1freesec); end;
     end;

    zxrootR[pos].name    :=zxrootR[n].name;
    zxrootR[pos].typ     :=zxrootR[n].typ;
    zxrootR[pos].start   :=zxrootR[n].start;
    zxrootR[pos].length  :=zxrootR[n].length;
    zxrootR[pos].totalsec:=zxrootR[n].totalsec;
    zxrootR[pos].mark    :=false;

    inc(pos);
    zxrootR[pos].name[1]:=#0;
   end else inc(fr,zxrootR[n].totalsec);
 end;

zxdiskR.files:=pos-2; zxdiskR.delfiles:=0;
inc(zxdiskR.free,fr);

saveFAT(right);
zxredraw;
end;







begin
end.