{$O+,F+,I-}
UNIT rPuts;
Interface
Uses
    crt,dos,rcrt,rstr,rdos,rcdrom;
Type
  ScreenImage = Array [0..13199] of Word;
  FrameRec    = Record
    Upperleft    : Word;
    LowerRight   : Word;
    ScreenMemory : ScreenImage;
  end;

Const
  eng=127; rus=128;
  run=1; pro=0;
var
  SnapShot       :^ScreenImage;
  FrameStore     :Array [1..10] of ^FrameRec;
  WindowNum      :Byte;

  menu_kod       :char;
  menu_f         :byte;
  menu_posx,
  menu_posy      :byte;
  menu_total     :byte;
  menu_name      :array[1..50] of string;
  menu_ins       :array[1..50] of boolean;
  menu_mayins    :boolean;
  menu_title     :string;
  menu_visible   :byte;

  scanf_esc      :boolean;

procedure ScrIni;

procedure SaveScr           (x1,y1,x2,y2:byte);
procedure RestScr;

procedure PutWin            (x1,y1,x2,y2:integer);
procedure SPutWin           (x1,y1,x2,y2:integer);
procedure PutTitleWin       (title:string; x1,y1,x2,y2:integer);
procedure SPutTitleWin      (title:string; x1,y1,x2,y2:integer);

procedure Message           (tekst:string);
function  WaitMessage       (tekst:string):byte;
procedure NotWaitMessage    (paper,ink:byte; tekst:string);
procedure ErrorMessage      (tekst:string);
function  ErrorWaitMessage  (tekst:string):byte;

procedure StatusBar         (s:string);
procedure CStatusBar        (paper,ink,papermark,inkmark,putfrom:byte; s:string);
procedure StatusLine        (paper,x,y:integer; s:string);
procedure StatusLineColor   (paper,ink,inkmark,x,y:integer; s:string);
procedure CStatusLineColor  (paper,ink,inkmark,y:integer; s:string);
procedure ProcessBar        (act,per,total:byte; title:string);

function  Question          (quest:string; lan:byte):boolean;
function  Sure              (lan:byte):boolean;
function  Stop              (lan:byte):boolean;

function  Scanf             (scanf_posx, scanf_posy:byte;
                             scanf_str:string;
                             scanf_total, scanf_visible,
                             scanf_cur:byte):string;
function  ChooseItem:byte;
function  GetScrStr         (x,y,len:integer):string;
function  ChooseDrive       :char;

Implementation

{============================================================================}
{== SCREEN INI ==============================================================}
{============================================================================}
procedure ScrIni;
var
   mx,my,ax,ay,i:integer;
begin
mx:=gmaxx; my:=gmaxy;
i:=0;
for ay:=0 to my-1 do
for ax:=0 to mx-1 do
 begin
  Mem[$B800:(mx*ay+ax+i)*2]:=176;
  Mem[$B800:(mx*ay+ax+i)*2+1]:=7*16+1;
 end;
end;
{============================================================================}
{== SAVE SCREEN =============================================================}
{============================================================================}
procedure SaveScr(x1,y1,x2,y2:byte);
begin
SnapShot:=Ptr($B800,$0000);
Inc(WindowNum);
New(FrameStore[WindowNum]);
With Framestore[WindowNum]^ do
 begin
  ScreenMemory:=SnapShot^;
  UpperLeft:=WindMin;
  LowerRight:=WindMax;
 end;
end;
{============================================================================}
{== RESTORE SCREEN ==========================================================}
{============================================================================}
procedure RestScr;
begin
{cmprint(1,15,1,1,strr(WindowNum)); readkey;}
With Framestore[WindowNum]^ do Snapshot^:=ScreenMemory;
Dispose(Framestore[WindowNum]);
Dec(WindowNum);
end;
{============================================================================}
{== PUT WINDOW ==============================================================}
{============================================================================}
procedure PutWin(x1,y1,x2,y2:integer);
var
   f:integer;
begin
ClrBox(x1,y1,x2,y2);
GotoXY(x1,y1); mWrite(#201);
for f:=1 to (x2-x1-1) do mWrite(#205); mWrite(#187);
for f:=1 to (y2-y1) do
 begin
  mPrint(x1,f+y1,#186); mPrint(x2,f+y1,#186);
 end;
GotoXY(x1,y2); mWrite(#200);
for f:=1 to (x2-x1-1) do mWrite(#205); mWrite(#188);
PrintSelf(black,darkgray,x1+2,y2+1,x2-x1+1);
for f:=y1+1 to y2+1 do PrintSelf(black,darkgray,x2+1,f,2);
end;
{============================================================================}
{== PUT WINDOW AND SAVE =====================================================}
{============================================================================}
procedure SPutWin(x1,y1,x2,y2:integer);
var
   f:integer;
begin
SaveScr(x1,y1,x2+2,y2+1);
PutWin(x1,y1,x2,y2);
end;
{============================================================================}
{== PUT TITLED WINDOW =======================================================}
{============================================================================}
procedure PutTitleWin(title:string; x1,y1,x2,y2:integer);
var
   f:integer;
begin
f:=(x1+x2)div 2;
PutWin(x1,y1,x2,y2);
mprint(x1,y1+2,#$C7+fill(x2-x1-1,#$C4)+#$B6);
mprint(f-(length(title) div 2),y1+1,title);
end;
{============================================================================}
{== PUT TITLED WINDOW AND SAVE ==============================================}
{============================================================================}
procedure SPutTitleWin(title:string; x1,y1,x2,y2:integer);
var
   f:integer;
begin
f:=(x1+x2)div 2;
SaveScr(x1,y1,x2+2,y2+1);
PutWin(x1,y1,x2,y2);
mprint(x1,y1+2,#$C7+fill(x2-x1-1,#$C4)+#$B6);
mprint(f-(length(title) div 2),y1+1,title);
end;
{============================================================================}
{== BASE MESSAGE ============================================================}
{============================================================================}
procedure BaseMessage(p,i:byte; tekst:string);
var cm:integer;
begin
CurOff;
cm:=textattr;
Colour(p,i);
sPutWin(round(halfmaxx-(Length(tekst)/2)-5),halfmaxy-4,round(halfmaxx+(Length(tekst)/2)+5),halfmaxy);
CMCentre(p,i,halfmaxy-2,tekst);
textattr:=cm;
end;
{============================================================================}
{== MESSAGE =================================================================}
{============================================================================}
procedure Message(tekst:string);
begin
BaseMessage(green,white,tekst);
waitkey;
RestScr;
end;
{============================================================================}
{== WAIT MESSAGE ============================================================}
{============================================================================}
function WaitMessage(tekst:string):byte;
var k:char;
begin
BaseMessage(cyan,yellow,tekst);
k:=readkey;
WaitMessage:=ord(k);
RestScr;
end;
{============================================================================}
{== NOT WAIT MESSAGE ========================================================}
{============================================================================}
procedure NotWaitMessage(paper,ink:byte; tekst:string);
begin
BaseMessage(paper,ink,tekst);
end;
{============================================================================}
{== ERROR MESSAGE ===========================================================}
{============================================================================}
procedure ErrorMessage(tekst:string);
begin
BaseMessage(red,white,tekst);
waitkey;
RestScr;
end;
{============================================================================}
{== ERROR WAIT MESSAGE ======================================================}
{============================================================================}
function ErrorWaitMessage(tekst:string):byte;
var k:char;
begin
BaseMessage(red,white,tekst);
k:=readkey;
ErrorWaitMessage:=ord(k);
RestScr;
end;
{============================================================================}
{== STATUS BAR ==============================================================}
{============================================================================}
procedure StatusBar(s:string);
var
   f,i:integer;
   col:boolean;
   paper,ink:integer;
   my:integer;
label skip;
begin
i:=1; my:=gmaxy;
paper:=lightgray;
col:=true;
CMPrint(paper,0,1,my,' ');
for f:=1 to Length(s) do
 begin
  if i>gmaxx then break;
  if s[f]='`' then goto skip;
  if (s[f]='~')and(s[f+1]='`') then begin col:=not col; goto skip; end;
  if col then
   begin CMPrint(paper,black,i+1,my,s[f]); Inc(i); end
  else
   begin CMPrint(paper,white,i+1,my,s[f]); Inc(i); end;
skip:
 end;
CMPrint(paper,0,i+1,my,Space(gmaxx-i));
end;
{============================================================================}
{== Color STATUS BAR ========================================================}
{============================================================================}
procedure CStatusBar (paper,ink,papermark,inkmark,putfrom:byte; s:string);
var
   f,i:integer;
   col:boolean;
   my:integer;
label skip;
begin
i:=1; my:=gmaxy;
col:=true;
if putfrom=1 then CMPrint(paper,0,1,my,' ') else CMPrint(papermark,0,1,my,' ');
for f:=1 to Length(s) do
 begin
  if i>gmaxx then break;
  if s[f]='`' then goto skip;
  if (s[f]='~')and(s[f+1]='`') then begin col:=not col; goto skip; end;
  if col then
   begin CMPrint(paper,ink,i+1,my,s[f]); Inc(i); end
  else
   begin CMPrint(papermark,inkmark,i+1,my,s[f]); Inc(i); end;
skip:
 end;
CMPrint(paper,0,i+1,my,Space(gmaxx-i));
end;
{============================================================================}
{== STATUS LINE =============================================================}
{============================================================================}
procedure StatusLine(paper,x,y:integer; s:string);
var
   f,i:integer;
   col:boolean;
label skip;
begin
i:=0;
col:=true;
CMPrint(paper,0,x,y,' ');
for f:=1 to Length(s) do
 begin
  if i>gmaxx then break;
  if s[f]='`' then goto skip;
  if (s[f]='~')and(s[f+1]='`') then begin col:=not col; goto skip; end;
  if col then
   begin CMPrint(paper,black,i+1+x,y,s[f]); Inc(i); end
  else
   begin CMPrint(paper,white,i+1+x,y,s[f]); Inc(i); end;
skip:
 end;
end;
{============================================================================}
{== STATUS LINE COLOR =======================================================}
{============================================================================}
procedure StatusLineColor(paper,ink,inkmark,x,y:integer; s:string);
var
   f,i:integer;
   col:boolean;
label skip;
begin
i:=0;
col:=true;
CMPrint(paper,0,x,y,' ');
for f:=1 to Length(s) do
 begin
  if i>gmaxx then break;
  if s[f]='`' then goto skip;
  if (s[f]='~')and(s[f+1]='`') then begin col:=not col; goto skip; end;
  if col then
   begin CMPrint(paper,ink,i+1+x,y,s[f]); Inc(i); end
  else
   begin CMPrint(paper,inkmark,i+1+x,y,s[f]); Inc(i); end;
skip:
 end;
end;
{============================================================================}
{== CENTRE STATUS LINE COLOR ================================================}
{============================================================================}
procedure CStatusLineColor(paper,ink,inkmark,y:integer; s:string);
var
   x,f,i:integer;
   col:boolean;
label skip;
begin
i:=0;
col:=true;
x:=halfmaxx-(length(s) div 2);
CMPrint(paper,0,x,y,' ');
for f:=1 to Length(s) do
 begin
  if i>gmaxx then break;
  if s[f]='`' then goto skip;
  if (s[f]='~')and(s[f+1]='`') then begin col:=not col; goto skip; end;
  if col then
   begin CMPrint(paper,ink,i+1+x,y,s[f]); Inc(i); end
  else
   begin CMPrint(paper,inkmark,i+1+x,y,s[f]); Inc(i); end;
skip:
 end;
end;
{============================================================================}
{== PROCESS BAR =============================================================}
{============================================================================}
procedure ProcessBar(act,per,total:byte; title:string);
var
   k:char;
   cm,m,a,b:integer;
   x1,x2,dx:byte;
   yes,no:string;
   ops:integer;
label l;
begin
dx:=4;
cm:=halfmaxy;
x1:=halfmaxx-round(total/2)-dx;
Colour(white,black);
if act=run then
 begin
  x2:=halfmaxx+round(total/2)+dx;
  sPutWin(x1,cm-3,x2,cm);
  cmprint(7,0,x1+5,cm-2,title);
  cmprint(7,0,x1+5,cm-1,fill(total,#177));
 end;
ops:=round((total/100)*per);
mprint(x1+4+ops,cm-1,#$DB);
end;
{============================================================================}
{== QESTION =================================================================}
{============================================================================}
function Question(quest:string; lan:byte):boolean;
var
   k:char;
   cm,m,a,b:integer;
   x1,x2,dx:byte;
   yes,no:string;
label l;
begin
CurOff;
if lan=rus then
 begin yes:='  '; no:= '  '; a:=round(maxx/2)-4; b:=round(maxx/2); end
else
 begin yes:=' Yes '; no:= ' No '; a:=round(maxx/2)-4; b:=round(maxx/2)+1; end;
cm:=halfmaxy;
if length(quest)<5 then dx:=5 else dx:=0;
x1:=halfmaxx-round(length(quest)/2)-3-dx;
x2:=halfmaxx+round(length(quest)/2)+3+dx;
SaveScr(x1,cm-4,x2+2,cm+3);
Colour(red,white); PutWin(x1,cm-4,x2,cm+2);
CStatusLineColor(red,white,lightgreen,cm-2,quest);
Colour(white,red); mPrint(a,cm,yes);
Colour(red,lightgray); mPrint(b,cm,no);
m:=1;
l:
 k:=ReadKey;
 if k=#27 then begin Question:=false; RestScr; Exit; end;
 if k=#13 then begin if m=0 then Question:=false else Question:=true; RestScr; Exit; end;
 if k=#0 then
  begin
   k:=ReadKey;
   if k=#77 then m:=0;
   if k=#75 then m:=1;
  end;
 if m=1 then
  begin
   Colour(white,red); mPrint(a,cm,yes);
   Colour(red,lightgray); mPrint(b,cm,no);
  end
 else
  begin
   Colour(red,lightgray); mPrint(a,cm,yes);
   Colour(white,red); mPrint(b,cm,no);
  end;
goto l;
end;
{============================================================================}
{== SURE ====================================================================}
{============================================================================}
function Sure(lan:byte):boolean;
var
   quest:string;
label l;
begin
CurOff;
if lan=rus then quest:=' 㢥७?' else quest:='Are you sure?';
sure:=question(quest,lan);
end;
{============================================================================}
{== STOP ====================================================================}
{============================================================================}
function Stop(lan:byte):boolean;
var
   quest:string;
label l;
begin
CurOff;
if lan=rus then quest:='ࢠ ?' else quest:='   Halt?    ';
stop:=question(quest,lan);
end;
{============================================================================}
{== SCANF ===================================================================}
{============================================================================}
function scanf(scanf_posx, scanf_posy:byte;
               scanf_str:string;
               scanf_total, scanf_visible,
               scanf_cur:byte):string;
var
     scanf_kod:char;
     scanf_x, scanf_from:byte;
     scanf_str_old:string;
label loop;
begin
scanf_esc:=false;
scanf_str_old:=scanf_str;
scanf_str:=scanf_str+space(scanf_total-length(scanf_str));
scanf_x:=scanf_cur;
scanf_from:=1;
if scanf_visible>length(scanf_str) then scanf_visible:=length(scanf_str);

loop:
mprint(scanf_posx,scanf_posy,copy(scanf_str,scanf_from,scanf_visible));
gotoxy(scanf_posx+scanf_x-scanf_from,scanf_posy);
scanf_kod:=readkey;
if scanf_kod=#27 then begin scanf:=scanf_str_old; scanf_esc:=true; exit; end;
if scanf_kod=#13 then begin scanf:=scanf_str; exit; end;

if ((scanf_kod)>=' ')and((scanf_kod)<='')and(scanf_x<=length(scanf_str)) then
 begin
  scanf_str:=copy(scanf_str,1,scanf_x-1)+scanf_kod+copy(scanf_str,scanf_x,length(scanf_str));
  scanf_str:=copy(scanf_str,1,length(scanf_str)-1);
  inc(scanf_x);
  if scanf_x-scanf_from>scanf_visible then inc(scanf_from);
  if scanf_x>length(scanf_str)+1 then scanf_x:=length(scanf_str)+1;
 end;

if scanf_kod=#8 then
 begin
  scanf_str:=copy(scanf_str,1,scanf_x-2)+copy(scanf_str,scanf_x,length(scanf_str));
  dec(scanf_x);
  if scanf_x<scanf_from then dec(scanf_from);
  if scanf_x<1 then scanf_x:=1 else scanf_str:=scanf_str+' ';
  if scanf_from<1 then scanf_from:=1;
  if scanf_x<1 then scanf_x:=1;
 end;

if scanf_kod=#25 then
 begin
  scanf_str:=space(scanf_total);
  scanf_from:=1;
  scanf_x:=1;
 end;

if scanf_kod=#0 then
 begin
  scanf_kod:=readkey;
  if scanf_kod=#71 then begin scanf_from:=1; scanf_x:=1; end;
{  if scanf_kod=#79 then begin scanf_from:=scanf_total-scanf_visible+1; scanf_x:=length(scanf_str); end;{}
  if scanf_kod=#83 then scanf_str:=copy(scanf_str,1,scanf_x-1)+copy(scanf_str,scanf_x+1,length(scanf_str))+' ';
  if scanf_kod=#77 then
   begin
    inc(scanf_x);
    if scanf_x-scanf_from>scanf_visible then inc(scanf_from);
   end;
  if scanf_kod=#75 then
   begin
    dec(scanf_x);
    if scanf_x<scanf_from then dec(scanf_from);
   end;

  if scanf_from<1 then scanf_from:=1;
  if scanf_x<1 then scanf_x:=1;
  if scanf_x>length(scanf_str)+1 then begin scanf_x:=length(scanf_str)+1; dec(scanf_from); end;
  if scanf_posx+scanf_x>gmaxx then scanf_x:=gmaxx-scanf_posx;
 end;

goto loop;
end;
{============================================================================}
{== CHOOSE ITEM =============================================================}
{============================================================================}
function ChooseItem:byte;
var
   f,inttemp,fr,a:integer;
   la:word; lx,ly:integer;
label loop;
procedure PutItems;
var
    f:byte;
    v,k:integer;
begin
if menu_visible>menu_total then v:=menu_total else v:=fr+menu_visible-1;
k:=1;
for f:=fr to v do
 begin
  if menu_title='' then
   begin
    if menu_ins[f] then colour(lightgray,white) else colour(lightgray,black);
    if f=menu_f then if menu_ins[f] then colour(blue,white) else colour(blue,lightcyan);
    mprint(menu_posx+2, menu_posy+k, '  '+menu_name[f]+'  ')
   end
  else
   begin
    if menu_ins[f] then colour(lightgray,white) else colour(lightgray,black);
    if f=menu_f then if menu_ins[f] then colour(blue,white) else colour(blue,lightcyan);
    mprint(menu_posx+2, menu_posy+k+2, '  '+menu_name[f]+'  ');
   end;
 inc(k);
 end;
end;
begin
la:=textattr; lx:=wherex; ly:=wherey;
if menu_visible=255 then menu_visible:=round(gmaxy/3);
if menu_visible>menu_total then menu_visible:=menu_total;
if (menu_visible<=0)or(menu_visible>gmaxy-9) then menu_visible:=gmaxy-9;
if (menu_f<1)or(menu_f>menu_total) then menu_f:=1;
inttemp:=length(menu_name[1]);
for f:=2 to menu_total do if length(menu_name[f])>inttemp then inttemp:=length(menu_name[f]);
if length(menu_title)>inttemp then inttemp:=length(menu_title);
if menu_posx=255 then menu_posx:=(halfmaxx)-round((6+inttemp)/2);
if menu_title<>'' then a:=2 else a:=2;
if menu_posy=255 then menu_posy:=round(halfmaxy-menu_visible/2)-a;
for f:=1 to menu_total do menu_name[f]:=menu_name[f]+space(inttemp-length(menu_name[f]));
colour(white,black);
if menu_visible>menu_total then f:=menu_total else f:=menu_visible;
if menu_title=''
then
 sputwin(menu_posx, menu_posy, menu_posx+inttemp+7, menu_posy+f+1)
else
  begin
   sputwin(menu_posx, menu_posy, menu_posx+inttemp+7, menu_posy+f+3);
   mprint(menu_posx, menu_posy+2, chr(199)+fill(inttemp+6,#196)+chr(182));
   mprint((menu_posx+round((inttemp+8)/2))-round((length(menu_title))/2), menu_posy+1, menu_title);
  end;
fr:=1;
loop:
  PutItems;
  menu_kod:=readkey;
  if menu_kod=#13 then
   begin
    restscr;
    ChooseItem:=menu_f;
    textattr:=la;
    gotoxy(lx,ly);
    menu_posx:=255; menu_posy:=255;
    exit;
   end;
  if menu_kod=#27 then
   begin
    restscr;
    ChooseItem:=0;
    menu_posx:=255; menu_posy:=255;
    exit;
   end;
  if menu_mayins then
   begin
    if menu_kod=#45 then begin for f:=1 to menu_total do menu_ins[f]:=false; end;
    if menu_kod=#43 then begin for f:=1 to menu_total do menu_ins[f]:=true; end;
    if menu_kod=#42 then begin for f:=1 to menu_total do menu_ins[f]:=not menu_ins[f]; end;
   end;
  if menu_kod=#0 then
   begin
    menu_kod:=readkey;
    if menu_mayins then
     begin
      if menu_kod=#82 then
       begin menu_ins[menu_f]:=not menu_ins[menu_f]; inc(menu_f); end;
     end;
    if menu_kod=#80 then
     begin
      inc(menu_f);
      if menu_f>fr+menu_visible-1 then begin inc(fr); if fr>menu_total-menu_visible+1 then dec(fr); end;
     end;
    if menu_kod=#72 then
     begin
      dec(menu_f);
      if menu_f<fr then begin dec(fr); if fr<1 then inc(fr); end;
     end;
   end;
  if menu_f>menu_total then menu_f:=menu_total;
  if menu_f<1 then menu_f:=1;
goto loop;
end;
{============================================================================}
{== GET STRING FROM SCREEN ==================================================}
{============================================================================}
function GetScrStr(x,y,len:integer):string;
var
 f,i,mx:byte;
 s:string;
begin
s:=''; mx:=maxx;
i:=0; Dec(x); Dec(y);
for f:=1 to len do
 begin
  s:=s+chr(Mem[$B800:(mx*y+x)*2+i]);
  Inc(i); Inc(i);
 end;
GetScrStr:=s;
end;
{============================================================================}
{== CHOOSE DRIVE ============================================================}
{============================================================================}
function ChooseDrive:char;
var r,s:string; i:integer; k:char; loc,sub:boolean;
label loop;
begin
r:=getalldrivers; s:='';
{r:='CDEFGHIJKLMNOPQRSTUVWXYZ';}
menu_total:=length(r); menu_title:='';
for i:=1 to length(r) do
 begin
  k:=r[i]; isdrivevalid(k,loc,sub);
  if sub then s:='Subst' else if loc then s:='Local' else s:='NetWork';
  if itcdrom(k) then s:='CD-ROM';
  menu_name[i]:=k+':  '+s;
 end;
menu_posx:=8; menu_posy:=3; menu_visible:=maxy-12;
i:=chooseitem; if i=0 then begin choosedrive:='0'; exit; end;
choosedrive:=r[i];
end;



BEGIN
menu_visible:=255;
menu_mayins:=false;
menu_posx:=255; menu_posy:=255;
END.
