{$O+,F+}
UNIT rdos;
Interface
Uses
    crt,dos{, puts5};
Const
    _dir=1; _name=2; _ext=3;
Type
    CpuType=(c8088,c8086,c80286,c80386,c80486,Pentium,PentiumPRO);
function LZ(w:Word):String;
function GetOf(fullpath:string; what:byte):string;

function RunBy:string;

function IsDriveValid(cDrive: Char; Var bLocal, bSUBST: Boolean): Boolean;
function GetAllDrivers:string;
function CheckDrv(drv:char):byte;
function CheckDir(direct:string):byte;
function CheckFile(myfile:string):byte;
function CheckDirFile(fullname:string):byte;
function CheckWrite(drv:char):boolean;

function FileTime(FileName: string): string;
function FileDate(FileName: string): string;
function FileLen(FileName: string): longint;

function GetVolSerialNo(DriveNo:Byte): string;
Function CreateDir(full:string):byte;
function CurentDir:string;

function GetProfile(filename,group,key:string; var str:string):byte;
function WriteProfile(filename,group,key,str:string):byte;

function CpuID(var cpun:integer) : string;
function CpuCLK:string;

function FindFile(findfilename:string):string;

procedure FileCreate(f:string);
procedure FileDelete(fn:string);
procedure MakeFile(name:string; bytes:longint; code:byte);

procedure Str2FileOfChr(fl:string; num:longint; s:string);
procedure Str2FileOfStr(name, str:string);

procedure FileCopy(source,dest:string);
procedure CopyData(source,dest:string; from,bytes:longint);

procedure Ecran(s:pointer);


Implementation


{----------------------------------------------------------------------------}
Function StrLo(s:string):string;
var
   f:integer;
   a,t:string;
   c:char;
Begin
a:='';
for f:=1 to Length(s) do
 begin
  t:=copy(s,f,1); c:=t[1];
  if (t>='A')and(t<='Z') then a:=a+chr(ord(c)+32) else a:=a+t;
 end;
StrLo:=a;
End;
{----------------------------------------------------------------------------}
Function StrHi(s:string):string;
var
   f:integer;
   a,t:string;
   c:char;
Begin
a:='';
for f:=1 to Length(s) do
 begin
  t:=copy(s,f,1); c:=t[1];
  if (t>='a')and(t<='z') then a:=a+chr(ord(c)-32) else a:=a+t;
 end;
StrHi:=a;
End;
{----------------------------------------------------------------------------}
Function NoSpace(s:string):string;
var
   f:integer;
   a:string;
Begin
a:='';
for f:=1 to Length(s) do if s[f]<>' ' then a:=a+s[f];
NoSpace:=a;
End;
{----------------------------------------------------------------------------}
Function Strr(tempein:longint):string;
var
   rrr:string;
Begin
str(tempein,rrr);
Strr:=rrr;
End;
{----------------------------------------------------------------------------}
Function Vall(tempein:string):longint;
var
   rrr:longint;
   code:integer;
Begin
Val(tempein,rrr,code);
Vall:=rrr;
End;
{----------------------------------------------------------------------------}
Function LZ(w:Word):String;
var
   s:String;
Begin
Str(w:0,s); if Length(s)=1 then s:='0'+s; LZ:=s;
End;
{============================================================================}
{== DIR OF ,   NAME OF ,   EXT OF ===========================================}
{============================================================================}
Function GetOf(fullpath:string; what:byte):string;
var
   dosdir  :dirstr;
   dosname :namestr;
   dosext  :extstr;
Begin
FSplit(fullpath, dosdir, dosname, dosext);
if length(dosdir) <> 3 then dosdir := Copy(dosdir, 1, Length(dosdir)-1);
case what of
 _dir  : GetOf := dosdir;
 _name : GetOf := dosname;
 _ext  : GetOf := dosext;
end;
End;
{============================================================================}
{== RUN UNDER ... ===========================================================}
{============================================================================}
Function RunBy:string;
var
  parentseg :^word;
  p         :pchar;
  i         :integer;
  s         :string;
begin
s:='';  i:=0;
parentseg:=ptr(prefixseg,$16);
p:=ptr(parentseg^-1,8);
while true do
 begin
  if p[i]=chr(0) then break;
  s:=s+p[i];
  inc(i);
 end;
runby:=s;
end;

{============================================================================}
{== IS THIS DRIVE VALID ? ===================================================}
{============================================================================}
Function IsDriveValid(cDrive: Char; Var bLocal, bSUBST: Boolean): Boolean;
Var
  regs:Registers;
Begin
if not (UpCase(cDrive) in ['A'..'Z']) then IsDriveValid:=False else
 begin
  regs.bx := ord(UpCase(cDrive)) - ord('A') + 1;
  regs.ax := $4409;
  Intr($21, regs);
  if (regs.ax and FCarry) = FCarry then IsDriveValid := False else
   begin
    IsDriveValid := True;
    bLocal := ((regs.dx and $1000) = $0000);
    if bLocal then bSUBST := ((regs.dx and $8000) = $8000) else bSUBST := False;
   end;
 end;
End;
{============================================================================}
{== GET ALL DRIVERS =========================================================}
{============================================================================}
Function GetAllDrivers:string;
var
  cCurChar       :Char;
  bLocal,bSUBST  :Boolean;
  s              :string;
Begin
s:='';
For cCurChar := 'C' to 'Z' do
 if IsDriveValid(cCurChar, bLocal, bSUBST) then s := s + cCurChar;
GetAllDrivers := s;
{GetAllDrivers := 'ABCDEFGHHIJKLMNOPQRSTUVWXYZ';}
End;
{============================================================================}
{== CHECK DRIVE =============================================================}
{============================================================================}
{$I-}
Function CheckDrv(drv:char):byte;
var
   f     :byte;
   drvs  :string;
   scd:string;
Begin
{drvs := GetAllDrivers; f := 1;
while (f <= length(drvs)) and (UpCase(drv) <> drvs[f]) do inc(f);
if f <= length(drvs) then CheckDrv := 0 else CheckDrv := 15;
}
getdir(0,scd);
chdir(drv+':\');
CheckDrv:=ioresult;
chdir(scd);
End;
{$I+}
{============================================================================}
{== CHECK DIRECTORY =========================================================}
{============================================================================}
{$I-}
Function CheckDir(direct:string):byte;
var
   s:string;
Begin
GetDir(0, s); ChDir(direct); CheckDir:=IOResult; ChDir(s);
End;
{$I+}
{============================================================================}
{== CHECK FILE ==============================================================}
{============================================================================}
{$I-}
Function CheckFile(myfile:string):byte;
var
   ff  :file of byte;
   a   :byte;
Begin
filemode := 0;
Assign(ff, myfile); Reset(ff); a := IOResult;
if a = 0 then Close(ff);
CheckFile := a;
End;
{$I+}
{============================================================================}
{== CHECK DIR+FILE ==========================================================}
{============================================================================}
Function CheckDirFile(fullname:string):byte;
var
   a        :byte;
   s        :string;
Begin
a:=CheckDir(GetOf(fullname,_dir));
if a <> 0 then
 begin
  CheckDirFile := a;
  Exit;
 end;
GetDir(0, s);
ChDir(GetOf(fullname, _dir));
CheckDirFile := CheckFile(GetOf(fullname, _name) + GetOf(fullname, _ext));
ChDir(s);
End;
{============================================================================}
{== CHECK DIR+FILE ==========================================================}
{============================================================================}
Function CheckWrite(drv:char):boolean;
var
a:string; f:file;
Begin
a:=curentdir;
if CheckDrv(drv)<>0 then begin CheckWrite:=false; exit; end;
ChDir(drv+':\');
assign(f,'RomanRom.2'); rewrite(f,1);
if ioresult<>0 then begin CheckWrite:=false; end
else begin close(f); erase(f); CheckWrite:=true; end;
ChDir(a);
End;
{============================================================================}
{== CREATE DIR ==============================================================}
{============================================================================}
{$I-}
function CreateDir(full:string):byte;
var
   cur:string;
   temp:string;
   ss:byte;
begin
temp:='';
GetDir(0,cur);
for ss:=1 to Length(full) do
 begin
  temp:=temp+Copy(full,ss,1);
  if Copy(full,ss,1)='\' then
   begin
    if length(temp)<>3 then
     begin
      if Copy(temp,Length(temp),1)='\' then temp:=Copy(temp,1,Length(temp)-1);
      if checkdir(temp)<>0 then MkDir(temp);
      temp:=temp+'\';
     end;
   end;
 end;
CreateDir:=CheckDir(Copy(full,1,Length(full)-1));
ChDir(cur);
end;
{$I+}
{============================================================================}
{== CURENT DIRECTORY ========================================================}
{============================================================================}
Function CurentDir:string;
var
   s:string;
Begin
Getdir(0,s); CurentDir:=s;
End;
{============================================================================}
{== FILE TIME ===============================================================}
{============================================================================}
Function FileTime(FileName: string): string;
var
   Srec : SearchRec;
   dt   : DateTime;
Begin
FindFirst(FileName, $01+$02+$04+$20, Srec);
if DosError = 0 then
 begin
  unpacktime(Srec.Time, dt);
  with dt do FileTime:=LZ(hour)+':'+LZ(min)+':'+LZ(sec);
 end
else FileTime := '';
End;
{============================================================================}
{== FILE DATE ===============================================================}
{============================================================================}
Function FileDate(FileName: string): string;
var
   Srec : SearchRec;
   dt   : DateTime;
Begin
FindFirst(FileName, $01+$02+$04+$20, Srec);
if DosError = 0 then
 begin
  unpacktime(Srec.Time, dt);
  with dt do FileDate:=LZ(day)+'-'+LZ(month)+'-'+Copy(LZ(year),3,2);
 end
else FileDate := '';
End;
{============================================================================}
{== FILE LENGTH =============================================================}
{============================================================================}
Function FileLen(FileName: string): longint;
var
   Srec: SearchRec;
Begin
FindFirst(FileName, $01+$02+$04+$20, Srec);
if DosError = 0 then FileLen := Srec.Size else FileLen := 0;
End;
{============================================================================}
{== GET SERIAL NUMBER OF DRIVE ==============================================}
{============================================================================}
Function HexDigit(N:Byte):char;
begin
if n<10 then HexDigit:=Chr(Ord('0')+n) else HexDigit:=Chr(Ord('A')+(n-10));
end;

Function GetVolSerialNo(DriveNo:Byte): string;
type
  SerNo_type=
   record
    case integer of
     0: (SerNo1,SerNo2:word);
     1: (SerNo:longint);
   end;
  DiskSerNoInfo_type=
   record
    Infolevel:word;
    VolSerNo:SerNo_Type;
    VolLabel:array[1..11] of char;
    FileSys:array[1..8] of char;
   end;
var
  ReturnArray:DiskSerNoInfo_type;
  Regs:Registers;
Begin
  with regs do
   begin
    AX:=$440d;
    BL:=DriveNo;
    CH:=$08;
    CL:=$66;
    DS:=Seg(ReturnArray);
    DX:=Ofs(ReturnArray);
    Intr($21,Regs);
    if (Flags and FCarry)<>0 then GetVolSerialNo:='' else
     with ReturnArray.VolSerNo do
     GetVolSerialNo:=
      HexDigit(Hi(SerNo2)Div 16)+HexDigit(Hi(SerNo2)Mod 16)+
      HexDigit(Lo(SerNo2)Div 16)+HexDigit(Lo(SerNo2)Mod 16)+
      HexDigit(Hi(SerNo1)Div 16)+HexDigit(Hi(SerNo1)Mod 16)+
      HexDigit(Lo(SerNo1)Div 16)+HexDigit(Lo(SerNo1)Mod 16);
   end;
End;
{============================================================================}
{== GET PROFILE FROM *.INI FILES ============================================}
{============================================================================}
Function GetProfile(filename,group,key:string; var str:string):byte;
var
   ft:text;
   fstr:string;
Begin
GetProfile:=checkdirfile(filename);
if checkdirfile(filename)<>0 then begin str:=''; exit; end;
assign(ft,filename); reset(ft);
while not EOF(ft) do
 begin
  readln(ft,fstr);
  if fstr='['+group+']' then break;
 end;
if fstr<>'['+group+']' then begin close(ft); str:=''; exit; end;
while not EOF(ft) do
 begin
  readln(ft,fstr);
  if copy(fstr,1,length(key))=key then break;
 end;
if copy(fstr,1,length(key))<>key then begin close(ft); str:=''; exit; end;
str:=copy(fstr,length(key)+2,160);
GetProfile:=0;
close(ft);
End;
{============================================================================}
{== WRITE PROFILE TO *.INI FILES ============================================}
{============================================================================}
Function WriteProfile(filename,group,key,str:string):byte;
type
  a=array[1..2] of string;
var
 err:byte;
 i:byte;
 ft:text;
 s:string;
 k:integer;
 f:^a;
 siz:word;
Begin {$R-}
siz:=filelen(filename);
if checkdirfile(filename)<>0 then filecreate(filename);
err:=ioresult; if err<>0 then begin writeprofile:=err; exit; end;
getmem(f,siz);
assign(ft,filename); reset(ft);
s:=''; k:=1;
while (s<>'['+group+']')and(not EOF(ft)) do begin readln(ft,s); f^[k]:=s; inc(k); end;
if EOF(ft) then
 begin
  f^[k]:=''; inc(k);
  f^[k]:='['+group+']'; inc(k); f^[k]:=key+'='+str; inc(k);
  while not EOF(ft) do begin readln(ft,s); f^[k]:=s; inc(k); end;
  close(ft); i:=(k-1); rewrite(ft);
  for k:=1 to i do writeln(ft,f^[k]); close(ft);
  freemem(f,siz);
  exit;
 end;
s:='-=-=-=-';
while (not EOF(ft))and(copy(s,1,length(key))<>key) do
 begin
  readln(ft,s);
  if (copy(s,1,1)='[') then begin inc(k); break; end;
  if (s)='' then break;
  f^[k]:=s; inc(k);
 end;
 if copy(s,1,length(key))=key then
  begin
   dec(k);
   f^[k]:=key+'='+str; inc(k);
   while not EOF(ft) do begin readln(ft,s); f^[k]:=s; inc(k); end;
   close(ft); i:=(k-1); rewrite(ft);
   for k:=1 to i do writeln(ft,f^[k]); close(ft);
   freemem(f,siz); exit;
  end;
f^[k]:=key+'='+str; inc(k); f^[k]:=''; inc(k);
while not EOF(ft) do begin readln(ft,s); f^[k]:=s; inc(k); end;
close(ft); i:=(k-1); rewrite(ft);
for k:=1 to i do writeln(ft,f^[k]); close(ft);
freemem(f,siz); exit;
{$R+}
end;
{============================================================================}
{== CPU ID ==================================================================}
{============================================================================}
{$L CPU.OBJ} {$F+} Function WhichCPU : CpuType; EXTERNAL; {$F-}
Function CpuID(var cpun:integer) : string;
Begin
  Case WhichCPU Of
    c8088:      begin CpuID := '8088';       cpun:=0; end;
    c8086:      begin CpuID := '8086';       cpun:=1; end;
    c80286:     begin CpuID := '80286';      cpun:=2; end;
    c80386:     begin CpuID := '80386';      cpun:=3; end;
    c80486:     begin CpuID := '80486';      cpun:=4; end;
    Pentium:    begin CpuID := 'Pentium';    cpun:=5; end;
    PentiumPRO: begin CpuID := 'PentiumPRO'; cpun:=6; end;
  End;
End;
{
             室 䠩 : CPU.OBJ
                          : 399 (1Kb)
                   ᮧ : 29--93 00:00:00
                ஢ : 15--97 02:40:36
                  UU- : 1Kb
              ⢮ ᥪ権 : 1
     ᫮ ப   ᥪ樨 : 9


section 1 of file cpu.obj  < uuencode by Dos Navigator >

filetime 454885376
begin 644 cpu.obj
M@`X`#&-P=6ED87-M+D%330&((````!Q4=7)B;R!!<W-E;6)L97(@(%9E<G-I
M;VX@,RXRF8@4`$#I-F?1&@QC<'5I9&%S;2Y!4TU"B`,`0.E,E@(``&B(`P!`
MH926!@`$0T]$1468!P!(\P`"`0$BD`\```$(5TA)0TA#4%4```#]B`0`0*(!
MD:#W``$``!Z,R([8Z!P`/`)]!>@P`.L1Z$D`/`-\"NAA`#P$?`/HA``?RYR<
M6X'C_P]3G9Q;@>,`\#/`@?L`\'0"L`*=PP:,R([`_;H!`+]8`+"0N0,`\ZK\
MD)"02I"0B\('PYP/`>#1V',%N`,`ZQ"X`'!0G9Q8@.1PN`(`=`%`G<.+^(O<
M9IQFG&989@T```0`9E!FG6:<9EAFJ0``!`!T`Y"01V:=B^.+Q\-FG&989HO8
M9C4``"``9E!FG6:<9EAF4V:=9B4``"``9H'C```@`&8[PW0>D)!FN`$````/
GHM'HT>C1Z-'HT>C1Z-'HT>@E#P##N`0`PZR<!0#$250!_8H"``!T
`
end
sum -r/size 41274/574 section (from "begin" to "end")
sum -r/size 17278/399 entire input file

}
{=================== END of CPU ID ==========================================}
{============================================================================}
{== CPU CLK =================================================================}
{============================================================================}
Function CpuCLK:string;
Var
   MHz,KHz:word;

Procedure CPUSpd(Var MHz, KHz:  Word);
Const
     Processor_cycles:Array[0..5] of Byte=(165,165,25,103,42,42);
                {Cycle times of 8086, 80186, 80286, 80386, 80486, Pentium}
{
 Notice that here I have defined the 8086 as a Processor type of 0 vice
 the returned value of 1 from WhatCPU.  Since the original code did not
 distinguish between the 8086 and the 80186, I can get away with this.
}
Var
   Ticks,Cycles,CPS:LongInt;
   Which_CPU:integer;
Function i86_to_i286:  Word;  Assembler;
Asm
   CLI
   MOV         CX,1234
   XOR         DX,DX
   XOR         AX,AX
   MOV         AL,$B8
   OUT         $43,AL
   IN          AL,$61
   OR          AL,1
   OUT         $61,AL
   XOR         AL,AL
   OUT         $42,AL
   OUT         $42,AL
   XOR         AX,AX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IDIV        CX
   IN          AL,$42
   MOV         AH,AL
   IN          AL,$42
   XCHG        AL,AH
   NEG         AX
   STI
End;
Function i386_to_i486:  Word;        Assembler;
Asm
   CLI
   MOV         AL,$B8
   OUT         $43,AL
   IN          AL,$61
   OR          AL,1
   OUT         $61,AL
   XOR         AL,AL
   OUT         $42,AL
   OUT         $42,AL
   DB 66H,$B8,00h,00h,00h,80h;
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   DB 66H,0FH,$BC,$C8;       {        BSF        ECX,EAX }
   IN          AL,42H
   MOV         AH,AL
   IN          AL,42H
   XCHG        AL,AH
   NEG         AX
   STI
End;

Begin
CPUid(Which_CPU);
If Which_cpu<3 Then Ticks:=i86_to_i286 Else Ticks:=i386_to_i486;
Cycles:=20*Processor_cycles[Which_CPU];
CPS:=(Cycles*119318) Div Ticks;
MHz:=CPS Div 100000;
KHz:=(CPS Mod 100000+500) Div 1000;
End;

Begin
CpuSpd(MHz, KHz);
CpuCLK:=strr(MHz)+'.'+strr(KHz)+' MHz';
end;
{============================================================================}
{== FIND FILE ===============================================================}
{============================================================================}
Function FindFile(findfilename:string):string;
var
   founds:string;
   found:boolean;
   alld:string;
   f:integer;

function FileScan(path:pathstr):boolean;
var
    srf:searchrec;
begin
filescan:=false;
FindFirst(path+'*.*', (archive or readonly or hidden or sysfile), srf);
while DosError=0 do with srf do
 begin
  if (attr and (archive or readonly or hidden or sysfile)<>0)
  and (name[1]<>'.') then if strlo(name) = findfilename then
   begin founds:=copy(path,1,length(path)-1); filescan:=true; exit; end;
  FindNext(srf);
 end;
end;

procedure DirectoryScan(path:pathstr);
var
    sr:searchrec;
begin
if FileScan(path) then begin found:=true; exit; end;
FindFirst(path+'*.*', directory, sr);
while DosError=0 do
with sr do
 begin
  if (attr and directory<>0)and(name[1]<>'.') then
   begin
      if found then begin findfile:=founds; exit; end;
      DirectoryScan(path+name+'\');
   end;
  FindNext(sr);
 end;
end;

begin
found:=false;
findfile:='';
findfilename:=strlo(findfilename);
findfilename:=getof(findfilename,_name)+getof(findfilename,_ext);
alld:=getalldrivers;
for f:=1 to length(alld) do
 begin
  directoryscan(copy(alld,f,1)+':\');
  if found then break;
 end;
if not found then findfile:='?';
end;
{============================================================================}
{== CREATE FILE =============================================================}
{============================================================================}
Procedure FileCreate(f:string);
var
   a:file of byte;
Begin
Assign(a,f); ReWrite(a); Close(a);
End;
{============================================================================}
{== DELETE FILE =============================================================}
{============================================================================}
{$I-}
Procedure FileDelete(fn:string);
var
   ft:file of byte;
Begin
assign(ft,fn); erase(ft);
End;
{============================================================================}
{== MAKE FILE ===============================================================}
{============================================================================}
procedure MakeFile(name:string; bytes:longint; code:byte);
var
   fb:file of byte;
   a:longint;
Begin
assign(fb,name);
rewrite(fb);
for a:=1 to bytes do write(fb,code);
close(fb);
End;
{============================================================================}
{== STRING TO FILE OF CHAR OR BYTE ==========================================}
{============================================================================}
Procedure Str2FileOfChr(fl:string; num:longint; s:string);
var
   f:longint;
   ft:file of char;
   ss:string;
   b:char;
Begin
filemode:=2;
Assign(ft,fl); Reset(ft);
Seek(ft,num);
for f:=1 to Length(s) do
 begin
  ss:=Copy(s,f,1);
  Write(ft,ss[1]);
 end;
{
 b:=chr(13); write(ft,b);
 b:=chr(10); write(ft,b);
}
End;
{============================================================================}
{== ADD STRING TO FILE ======================================================}
{============================================================================}
Procedure Str2FileOfStr(name, str:string);
var
   ft:text;
Begin
assign(ft,name);
append(ft);
writeln(ft,str);
close(ft);
End;
{============================================================================}
{== COPY FILE ===============================================================}
{============================================================================}
Procedure FileCopy(source,dest:string);
var
   frfile,tofile:file;
   numread,numwritten:integer;
   buf:array[1..16384] of byte;
   ftime:longint;
   attr:word;
   k:char;
Begin
    filemode:=0;
    assign(frfile,source); reset(frfile,1);
    assign(tofile,dest);
    getfattr(tofile,attr); if attr and ReadOnly <> 0 then setfattr(dest,(attr xor ReadOnly));
    getfattr(tofile,attr); if attr and Hidden <> 0 then setfattr(dest,(attr xor Hidden));
    getfattr(tofile,attr); if attr and SysFile <> 0 then setfattr(dest,(attr xor SysFile));
    rewrite(tofile,1);
    repeat
     if keypressed then
      begin
       k:=readkey;
       if k=#27 then break;
      end;
     blockread(frfile,buf,sizeof(buf),numread);
     if filesize(frfile)=0 then break;
     blockwrite(tofile,buf,numread,numwritten);
    until (numread=0)or(numwritten<>numread);
    getftime(frfile,ftime); setftime(tofile,ftime);
    close(frfile); close(tofile);
End;
{============================================================================}
{== COPY DATA ===============================================================}
{============================================================================}
Procedure CopyData(source,dest:string; from,bytes:longint);
var
   frfile,tofile:file;
   numread,numwritten:integer;
   buf:array[1..16384] of byte;
   ftime:longint;
   attr:word;
   k:char;
   r,a,i:longint;
Begin
    filemode:=0;
    assign(frfile,source); reset(frfile,1);
    assign(tofile,dest);
    getfattr(tofile,attr); if attr and ReadOnly <> 0 then setfattr(dest,(attr xor ReadOnly));
    getfattr(tofile,attr); if attr and Hidden <> 0 then setfattr(dest,(attr xor Hidden));
    getfattr(tofile,attr); if attr and SysFile <> 0 then setfattr(dest,(attr xor SysFile));
    rewrite(tofile,1);
    seek(frfile,from);
    a:=round(int(bytes/sizeof(buf)));
    r:=round(bytes-a*sizeof(buf));
    if r<0 then r:=0;
    for i:=1 to a do
     begin
      if keypressed then begin k:=readkey; if k=#27 then break; end;
      blockread(frfile,buf,sizeof(buf),numread);
      if filesize(frfile)=0 then break;
      blockwrite(tofile,buf,numread,numwritten);
      if keypressed then begin k:=readkey; if k=#27 then break; end;
     end;
    blockread(frfile,buf,r,numread);
    blockwrite(tofile,buf,numread,numwritten);
    getftime(frfile,ftime); setftime(tofile,ftime);
    close(frfile); close(tofile);
End;
{============================================================================}
{== ECRAN ===================================================================}
{============================================================================}
procedure Ecran(s:pointer);
var
 se:word;
begin
 if (Lo(lastmode)=7) then se:=$B000 else se:=$B800;
 Move(s^,Ptr(se,0)^,4000);
end;



BEGIN
END.
